SET nocount ON

/********************************************************************** 
**  SQL_Mangler_Script.sql 
** 
**  Mangler for Primavera SQL Server 
** 
**  Modified 22-Jan-2019
** 
**  Description: Changes contents of string and memo fields in  
**  Primavera PMDB database. 
** 
**  Req:   
**  1. Run as 'sa' 
***********************************************************************/
DECLARE @tab_owner  VARCHAR(30),
        @v_process  BIT,
        @blob_col   VARCHAR(30),
        @v_pad_char VARCHAR(4000)
DECLARE @v_key_cnt    INT,
        @v_key_name   VARCHAR(255),
        @v_pk_column  VARCHAR(255),
        @v_pk_column2 VARCHAR(255)
DECLARE @vsql     NVARCHAR(4000),
        @v_upd    NVARCHAR(4000),
        @dummy    INT,
        @v_prefix VARCHAR(3)
DECLARE @ptr      BINARY(16),
        @tbptr    BINARY(16),
        @len      INTEGER,
        @pk       INTEGER,
        @v_remain INT,
        @v_offset INT
DECLARE @ParmDefinition NVARCHAR(500),
		@errVal int,
		@rCount int

-- Get table owner 
SELECT @tab_owner = su.name
FROM   sysobjects so,
       sysusers su
WHERE  so.name = 'PREFER'
       AND su.uid = so.uid

DECLARE @table_name  VARCHAR(30),
        @column_name VARCHAR(30),
        @col_length  SMALLINT
DECLARE tables CURSOR FOR
  SELECT Upper(so.name) table_name,
         Upper(sc.name) colname,
         sc.length
  FROM   syscolumns sc,
         sysobjects so
  WHERE  sc.xtype = 167
         AND so.type = 'U'
         AND sc.id = so.id
         AND sc.name NOT IN ( 'GUID', 'TMPL_GUID', 'PASSWD', 'UDF_TYPE_NAME',
                              'RPT_STATE', 'WINDOW_START', 'WINDOW_END',
                              'DATABASE_VERSION',
                              'TABLE_NAME', 'SETTING_NAME',
                              'DASHBOARD_LAYOUT_DATA',
                                  'FORMULA',
                              'RSRC_PRIVATE', 'VIEW_NAME', 'ISSUPERUSER',
                              'UDF_TYPE_LABEL' )
         AND so.name NOT IN ( 'ADMIN_CONFIG', 'BRE_REGISTRY', 'CURRTYPE',
                              'USESSION',
                              'REFRDEL', 'HQUERY', 'NEXTKEY', 'PUBUSER',
                              'LOCATION', 'QUERYLIB', 'PKXREF', 'USERCOL',
                              'USERSET', 'REITTYPE', 'M2_LOG', 'PROJPROP',
                              'RSRCPROP', 'PROJSHAR', 'VWPREFDATA', 'ATTR_MASTER' )
         AND sc.name NOT LIKE '%\_FLAG' ESCAPE '\'
         AND sc.name NOT LIKE '%\_TYPE' ESCAPE '\'
         AND sc.name NOT LIKE '%\_TYPE2' ESCAPE '\'
         AND sc.name NOT LIKE '%\_CHAR' ESCAPE '\'
         AND sc.name NOT LIKE '%\_KEY' ESCAPE '\'
         AND sc.name NOT LIKE '%\_SCOPE' ESCAPE '\'
         AND sc.name NOT LIKE '%\_LEVEL' ESCAPE '\'
         AND sc.name NOT LIKE '%\_ABBREV' ESCAPE '\'
         AND sc.name NOT LIKE 'STATUS%'
         AND sc.name NOT LIKE '%\_PRIVATE' ESCAPE '\'
         AND sc.name NOT LIKE '%_INTERVAL' ESCAPE '\'
		 AND sc.length > 1
  UNION
  SELECT 'ACTVTYPE'       table_name,
         'ACTV_CODE_TYPE' colname,
         '40'             'col_length'
  UNION
  SELECT 'BASETYPE'  table_name,
         'BASE_TYPE' colname,
         '40'        'col_length'
  UNION
  SELECT 'RISKTYPE'  table_name,
         'RISK_TYPE' colname,
         '40'        'col_length'
  UNION
  SELECT 'MEMOTYPE'  table_name,
         'MEMO_TYPE' colname,
         '40'        'col_length'
  UNION
  SELECT 'PCATTYPE'       table_name,
         'PROJ_CATG_TYPE' colname,
         '40'             'col_length'
  UNION
  SELECT 'RCATTYPE'      table_name,
         'RSRC_CATG_TYPE'colname,
         '40'            'col_length'
  ORDER  BY 1,
            2;

BEGIN TRAN T1;

OPEN tables;

FETCH tables INTO @table_name, @column_name, @col_length

WHILE ( @@FETCH_STATUS = 0 )
  BEGIN
      SET @v_process = 1
      SET @v_pk_column = NULL;
      SET @v_pk_column2 = NULL;

      SELECT @v_pk_column = Index_col(po.name, i.indid, 1),
             @v_pk_column2 = Index_col(po.name, i.indid, 2)
      FROM   sysobjects pk,
             sysobjects po,
             sysindexes i
      WHERE  pk.xtype = 'PK'
             AND po.id = pk.parent_obj
             AND po.name = @table_name
             AND i.name = pk.name;

      IF Len(@v_pk_column2) > 0
        SET @v_key_cnt = 2
      ELSE IF Len(@v_pk_column) > 0
        SET @v_key_cnt = 1

      SELECT @dummy = Count(*)
      FROM   nextkey
      WHERE  key_name = Lower(@table_name + '_' + @v_pk_column);

      IF @dummy <> 1
         AND @table_name NOT IN ( 'PREFER', 'UDFVALUE', 'WKFLUSER' )
        SET @v_process = 0

      IF @v_process = 1
        BEGIN
            PRINT 'Mangling ' + @table_name + '.' + @column_name

            IF @column_name = 'TASK_CODE'
              SET @v_prefix = 'A'
            ELSE
              SET @v_prefix = Substring(@table_name, 1, 1)

            IF @column_name = 'USER_NAME'
				BEGIN
              EXEC Sp_executesql N'update users set user_name = ''U'' + convert(varchar(10),user_id)'
					SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT;
					IF (@errVal <> 0)
						PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
					PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));
				END
            ELSE IF @column_name LIKE '%SHORT_NAME'
              BEGIN
                  SET @v_upd = 'update ' + @table_name + ' set ' + @column_name
                               + ' = ''' + @v_prefix + ''' + convert(varchar('
                               + Cast(@col_length AS VARCHAR(5)) + '),'
                               + @v_pk_column + ')'

                  EXEC Sp_executesql @v_upd
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT;
					IF (@errVal <> 0)
						PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
					PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));
              END
            ELSE
              BEGIN
                  -- With padding 
                  SET @v_upd = 'update ' + @table_name
                  SET @v_upd = @v_upd + ' set ' + @column_name + ' = '''
                               + @v_prefix + ''' + convert(varchar('
                               + Cast(@col_length AS VARCHAR(5)) + '),'
                               + @v_pk_column + ') + '' '' +'
                               + ' replicate(''xX'',(len(' + @column_name
                               + ')-len(convert(varchar('
                               + Cast(@col_length AS VARCHAR(5)) + '),'
                               + @v_pk_column + '))-2)/2)'
                  SET @v_upd = @v_upd + ' where len(''' + @v_prefix
                               + ''' +convert(varchar('
                               + Cast(@col_length AS VARCHAR(5)) + '),'
                               + @v_pk_column + ') ) ' + ' < len (' +
                               @column_name
                               + ')'

                  EXEC Sp_executesql @v_upd
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT;
				  IF (@errVal <> 0)
						PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
				  PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));
                  -- Without padding 
                  SET @v_upd = 'update ' + @table_name
                   SET @v_upd = @v_upd + ' set ' + @column_name + ' = Substring(('''
                               + @v_prefix + ''' + convert(varchar('
                               + Cast(@col_length AS VARCHAR(6)) + '),'
                               + @v_pk_column + ')),1,len(' +
							   @column_name
                               + '))'
                  SET @v_upd = @v_upd + ' where len(''' + @v_prefix
                               + ''' +convert(varchar('
                               + Cast(@col_length AS VARCHAR(5)) + '),'
                               + @v_pk_column + ')) ' + ' >= len (' +
                               @column_name
                               + ')'

                  EXEC Sp_executesql @v_upd
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT;
					IF (@errVal <> 0)
						PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
					PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));
              END
        END
      ELSE
        PRINT @table_name + '.' + @column_name + ' does not contain sensitive data.'

	  PRINT '--------------------------'
      FETCH tables INTO @table_name, @column_name, @col_length
  END

CLOSE tables

DEALLOCATE tables
COMMIT TRAN T1;

UPDATE users
SET    passwd = NULL;

DECLARE @blank_blobs BIT

SET @blank_blobs = 1

CREATE TABLE #temp_blob
  (
     pk       INT IDENTITY (1, 1),
     blobdata TEXT,
     tptr     BINARY(16)
  );

DECLARE blobs CURSOR FOR
  SELECT so.name table_name,
         sc.name column_name
  FROM   systypes st,
         syscolumns sc,
         sysobjects so
  WHERE  sc.id = so.id
         AND so.xtype = 'U'
         AND st.xtype = sc.xtype
         AND st.name = 'text'
         AND Upper(sc.name) NOT IN ( 'PROP_VALUE' )
         AND Upper(sc.name) NOT LIKE '%\_DATA' ESCAPE '\'
         order by 1,2;

BEGIN TRAN T2;
OPEN blobs;

FETCH blobs INTO @table_name, @blob_col

WHILE ( @@FETCH_STATUS = 0 )
  BEGIN
	  PRINT 'Mangling ' + @table_name + '.' + @blob_col
      SET @v_process = 1

      SELECT @v_pk_column = Index_col(po.name, i.indid, 1),
             @v_pk_column2 = Index_col(po.name, i.indid, 2)
      FROM   sysobjects pk,
             sysobjects po,
             sysindexes i
      WHERE  pk.xtype = 'PK'
             AND po.id = pk.parent_obj
             AND po.name = @table_name
             AND i.name = pk.name;

      IF Len(@v_pk_column2) > 0
        SET @v_key_cnt = 2
      ELSE IF Len(@v_pk_column) > 0
        SET @v_key_cnt = 1

      SELECT @dummy = Count(*)
      FROM   nextkey
      WHERE  key_name = Lower(@table_name + '_' + @v_pk_column);

      IF @dummy <> 1
         AND @table_name NOT IN ( 'PREFER', 'UDFVALUE', 'WKFLUSER' )
        SET @v_process = 0

      IF @v_process = 1
        BEGIN
            IF @blank_blobs = 1
              BEGIN
                  PRINT 'Simple Mangling blob ' + @table_name + '.' + @blob_col

                  SET @v_upd = 'update ' + @table_name + ' set ' + @blob_col
                               + ' = replicate(''xX'',datalength('
                               + @blob_col + '))' + ' where datalength('
                               + @blob_col + ') <= 8000'

				  EXEC Sp_executesql @v_upd
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT
                  IF (@errVal <> 0)
					PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
				  PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8)); 

                  SET @v_upd = 'update ' + @table_name + ' set ' + @blob_col
                               + ' = replicate(''xX'',8000)'
                               + ' where datalength(' + @blob_col + ') > 8000'

                  EXEC Sp_executesql @v_upd
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT
                  IF (@errVal <> 0)
					PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
				  PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));
              END
            ELSE
              BEGIN
                  PRINT 'Mangling blob ' + @table_name + '.' + @blob_col

                  DELETE FROM #temp_blob

                  SELECT @vsql = 'insert into #temp_blob (blobdata, tptr) select '
                  + @blob_col + ', TEXTPTR(' + @blob_col + ') from '
                  + @table_name + ' where ' + @blob_col + ' is not null'

                  EXEC Sp_executesql @vsql
                  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT
                  IF (@errVal <> 0)
					PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
				  PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));

                  PRINT @table_name + '.' + @blob_col

                  SELECT pk, Datalength(blobdata), ptr
                  FROM   #temp_blob

                  DECLARE udcur CURSOR FOR
                    SELECT Datalength (blobdata), tptr, Textptr(blobdata), pk
                    FROM   #temp_blob;

                  OPEN udcur

                  FETCH next FROM udcur INTO @len, @ptr, @tbptr, @pk

                  WHILE ( @@FETCH_STATUS = 0 )
        BEGIN
						PRINT 'pk = ' + Str(@pk)

            SET @v_remain = @len
            SET @v_offset = 0

            IF @v_remain < 4000
              SET @v_pad_char = Replicate('X', @v_remain + ( @v_remain%2 ))
            ELSE
              SET @v_pad_char = Replicate('X', 4000)

            WHILE ( @v_remain > 0 )
              BEGIN
							  SET @vsql = N'updatetext ' + @table_name + '.' + @blob_col + ' @pptr @pupdp @pdelp @prepl'
                  SET @ParmDefinition = N'@pptr binary(16),@pupdp int,@pdelp int,@prepl varchar(3)'

                  EXECUTE Sp_executesql
                    @vsql,
                    @ParmDefinition,
                    @pptr = @ptr,
                    @pupdp = @v_offset,
                    @pdelp = @v_remain,
                    @prepl = @v_pad_char
							  SELECT @errVal = @@ERROR, @rCount = @@ROWCOUNT
							  IF (@errVal <> 0)
								PRINT N'Error = ' + CAST(@errVal AS NVARCHAR(8));
							  PRINT N'Rows Updated = ' + CAST(@rCount AS NVARCHAR(8));

                  SET @v_remain = @v_remain - 4000
                  SET @v_offset = @v_offset + 4000
              END
        END

                  FETCH next FROM udcur INTO @len, @ptr, @tbptr, @pk

                  CLOSE udcur

                  DEALLOCATE udcur
              END
        END

	  PRINT '--------------------------'
      FETCH blobs INTO @table_name, @blob_col
  END

CLOSE blobs

DEALLOCATE blobs
COMMIT TRAN T2;

DROP TABLE #temp_blob;

go  
