
SET QUOTED_IDENTIFIER ON

print 'Dropping constraint fk_prefer_users2 on table PREFER'


--METADATA NAME:fk_prefer_users2 TYPE:CONSTRAINT TABLE_NAME:PREFER CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_prefer_users2';
if @cons_cnt > 0  
ALTER TABLE PREFER DROP CONSTRAINT fk_prefer_users2;
go

print 'Dropping index ndx_projrisk_obs on table PROJRISK'

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DROP INDEX PROJRISK.ndx_projrisk_obs;
      go

print 'Dropping index ndx_projrisk_projwbs on table PROJRISK'

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:DROP
DROP INDEX PROJRISK.ndx_projrisk_projwbs;
      go

print 'Dropping constraint fk_projrisk_obs on table PROJRISK'


--METADATA NAME:fk_projrisk_obs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_obs';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_obs;
go

print 'Dropping constraint fk_projrisk_project on table PROJRISK'


--METADATA NAME:fk_projrisk_project TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_project';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_project;
go

print 'Dropping constraint fk_projrisk_risktype on table PROJRISK'


--METADATA NAME:fk_projrisk_risktype TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_risktype';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_risktype;
go

print 'Dropping constraint fk_projrisk_rsrc on table PROJRISK'


--METADATA NAME:fk_projrisk_rsrc TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_rsrc';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_rsrc;
go

print 'Dropping constraint fk_projrisk_projwbs on table PROJRISK'


--METADATA NAME:fk_projrisk_projwbs TYPE:CONSTRAINT TABLE_NAME:PROJRISK CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_projrisk_projwbs';
if @cons_cnt > 0  
ALTER TABLE PROJRISK DROP CONSTRAINT fk_projrisk_projwbs;
go

print 'Dropping constraint fk_riskctrl_project on table RISKCTRL'


--METADATA NAME:fk_riskctrl_project TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_riskctrl_project';
if @cons_cnt > 0  
ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_project;
go

print 'Dropping constraint fk_riskctrl_projrisk on table RISKCTRL'


--METADATA NAME:fk_riskctrl_projrisk TYPE:CONSTRAINT TABLE_NAME:RISKCTRL CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_riskctrl_projrisk';
if @cons_cnt > 0  
ALTER TABLE RISKCTRL DROP CONSTRAINT fk_riskctrl_projrisk;
go

print 'Dropping constraint fk_tasksum_project on table TASKSUM'


--METADATA NAME:fk_tasksum_project TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksum_project';
if @cons_cnt > 0  
ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_project;
go

print 'Dropping constraint fk_tasksum_projwbs on table TASKSUM'


--METADATA NAME:fk_tasksum_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksum_projwbs';
if @cons_cnt > 0  
ALTER TABLE TASKSUM DROP CONSTRAINT fk_tasksum_projwbs;
go

print 'Dropping constraint fk_tasksumfin_findates on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_findates TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_findates';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_findates;
go

print 'Dropping constraint fk_tasksumfin_project on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_project TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_project';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_project;
go

print 'Dropping constraint fk_tasksumfin_projwbs on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_projwbs TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_projwbs';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_projwbs;
go

print 'Dropping constraint fk_tasksumfin_tasksum on table TASKSUMFIN'


--METADATA NAME:fk_tasksumfin_tasksum TYPE:CONSTRAINT TABLE_NAME:TASKSUMFIN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_tasksumfin_tasksum';
if @cons_cnt > 0  
ALTER TABLE TASKSUMFIN DROP CONSTRAINT fk_tasksumfin_tasksum;
go

print 'Dropping constraint fk_timesht_rsrc on table TIMESHT'


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_timesht_rsrc';
if @cons_cnt > 0  
ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_rsrc;
go

print 'Dropping constraint fk_timesht_tsdates on table TIMESHT'


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_timesht_tsdates';
if @cons_cnt > 0  
ALTER TABLE TIMESHT DROP CONSTRAINT fk_timesht_tsdates;
go

print 'Dropping constraint fk_trsrcsum_project on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_project';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_project;
go

print 'Dropping constraint fk_trsrcsum_roles on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_roles';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_roles;
go

print 'Dropping constraint fk_trsrcsum_rsrc on table TRSRCSUM'


--METADATA NAME:fk_trsrcsum_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUM CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsum_rsrc';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUM DROP CONSTRAINT fk_trsrcsum_rsrc;
go

print 'Dropping constraint fk_trsrcsumfn_findates on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_findates TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_findates';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_findates;
go

print 'Dropping constraint fk_trsrcsumfn_project on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_project TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_project';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_project;
go

print 'Dropping constraint fk_trsrcsumfn_roles on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_roles TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_roles';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_roles;
go

print 'Dropping constraint fk_trsrcsumfn_rsrc on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_rsrc TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_rsrc';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_rsrc;
go

print 'Dropping constraint fk_trsrcsumfn_trsrcsum on table TRSRCSUMFN'


--METADATA NAME:fk_trsrcsumfn_trsrcsum TYPE:CONSTRAINT TABLE_NAME:TRSRCSUMFN CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trsrcsumfn_trsrcsum';
if @cons_cnt > 0  
ALTER TABLE TRSRCSUMFN DROP CONSTRAINT fk_trsrcsumfn_trsrcsum;
go

print 'Dropping constraint ck_usereng_named_user_flag on table USERENG'


--METADATA NAME:ck_usereng_named_user_flag TYPE:CONSTRAINT TABLE_NAME:USERENG CHANGE:DROP
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='ck_usereng_named_user_flag';
if @cons_cnt > 0  
ALTER TABLE USERENG DROP CONSTRAINT ck_usereng_named_user_flag;
go

print 'Creating table DISCUSSION'

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION(
  "discussion_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "discussion_value"  varchar(4000) NULL,
  "discussion_date"  datetime NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion PRIMARY KEY (discussion_id)  )


go
print 'Creating table DISCUSSION_READ'

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE
CREATE TABLE DISCUSSION_READ(
  "discussion_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_discussion_read PRIMARY KEY (discussion_id,user_id)  )


go
print 'Creating table DOCREVIEW'

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEW(
  "doc_review_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_name"  varchar(255) NULL,
  "review_descr"  varchar(255) NULL,
  "review_type"  varchar(15) NULL,
  "due_date"  datetime NULL,
  "status"  varchar(15) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_docreview PRIMARY KEY (doc_review_id)  )


go
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,162,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=162)
go
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,163,case p.allow_flag when 'Y' then 'Y' else 'N' END,getdate(),session_user from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=163)
go

print 'Creating table DOCREVIEWTASK'

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE DOCREVIEWTASK(
  "review_task_id"  integer NOT NULL,
  "doc_review_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_date"  datetime NULL,
  "comments"  varchar(4000) NULL,
  "priority"  integer NULL,
  "status"  varchar(15) NULL,
  "attachment_uuid"  varchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_docreviewtask PRIMARY KEY (review_task_id)  )


go
print 'Creating table IMAGEDATA'

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE
CREATE TABLE IMAGEDATA(
  "image_id"  integer NOT NULL,
  "image_name"  varchar(120) NULL,
  "image_data"  varbinary(max) NOT NULL,
  "image_thumbnail"  varbinary(max) NOT NULL,
  "image_extension"  varchar(20) DEFAULT 'png' NOT NULL,
  "default_flag"  varchar(1) NOT NULL,
  "image_purpose"  varchar(50) NOT NULL,
  "image_description"  varchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_imagedata PRIMARY KEY (image_id)  )


go
print 'Creating table LOCATION'

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE
CREATE TABLE LOCATION(
  "location_id"  integer NOT NULL,
  "location_name"  varchar(255) NOT NULL,
  "location_type"  varchar(24) NULL,
  "address_line1"  varchar(200) NULL,
  "address_line2"  varchar(200) NULL,
  "address_line3"  varchar(200) NULL,
  "city_name"  varchar(200) NULL,
  "municipality_name"  varchar(200) NULL,
  "state_name"  varchar(200) NULL,
  "state_code"  varchar(2) NULL,
  "country_name"  varchar(200) NULL,
  "country_code"  varchar(3) NULL,
  "postal_code"  varchar(20) NULL,
  "longitude"  DECIMAL(28,10) NULL,
  "latitude"  DECIMAL(28,10) NULL,
  "geo_location"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_location PRIMARY KEY (location_id)  )


go
print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )


go
print 'Creating table SUMPROJCOST'

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMPROJCOST(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "cost_type_id"  integer NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  varchar(20) NULL,
  "act_cost"  numeric(23,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "target_cost"  numeric(23,6) NULL,
  "total_cost"  numeric(23,6) NULL
  )


go
print 'Creating table SUMTASK'

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASK(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "complete_cnt"  integer NULL,
  "active_cnt"  integer NULL,
  "notstarted_cnt"  integer NULL,
  "base_complete_cnt"  integer NULL,
  "base_active_cnt"  integer NULL,
  "base_notstarted_cnt"  integer NULL,
  "act_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_drtn_hr_cnt"  numeric(17,6) NULL,
  "base_drtn_hr_cnt"  numeric(17,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_float_hr_cnt"  numeric(17,6) NULL,
  "act_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "base_end_date"  datetime NULL,
  "base_start_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "act_this_per_work_cost"  numeric(25,6) NULL,
  "act_this_per_work_qty"  numeric(22,6) NULL,
  "act_this_per_equip_cost"  numeric(25,6) NULL,
  "act_this_per_equip_qty"  numeric(22,6) NULL,
  "act_this_per_mat_cost"  numeric(25,6) NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "target_drtn_hr_cnt"  numeric(17,6) NULL
  )


go
--METADATA  TYPE:ADHOC_SQL
UPDATE prefer SET phase_label='WBS Category',update_date=getdate(),update_user=session_user 
go
--METADATA  TYPE:ADHOC_SQL
UPDATE projwbs SET sum_data_flag='N' where sum_data_flag != 'N'
go
--METADATA  TYPE:ADHOC_SQL
UPDATE project SET last_tasksum_date=null where last_tasksum_date is not null
go

print 'Creating table SUMTASKSPREAD'

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTASKSPREAD(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "end_date"  datetime NOT NULL,
  "spread_type"  varchar(20) NOT NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "late_remain_cost"  numeric(25,6) NULL,
  "late_remain_equip_cost"  numeric(25,6) NULL,
  "late_remain_expense_cost"  numeric(25,6) NULL,
  "late_remain_mat_cost"  numeric(25,6) NULL,
  "late_remain_work_cost"  numeric(25,6) NULL,
  "late_remain_equip_qty"  numeric(22,6) NULL,
  "late_remain_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_cost"  numeric(25,6) NULL,
  "fin_period_act_equip_qty"  numeric(22,6) NULL,
  "fin_period_act_equip_cost"  numeric(25,6) NULL,
  "fin_period_act_mat_cost"  numeric(25,6) NULL,
  "fin_period_act_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_work_qty"  numeric(22,6) NULL,
  "fin_period_total_work_cost"  numeric(25,6) NULL,
  "fin_period_total_equip_qty"  numeric(22,6) NULL,
  "fin_period_total_equip_cost"  numeric(25,6) NULL,
  "fin_period_total_mat_cost"  numeric(25,6) NULL,
  "fin_period_total_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_cost"  numeric(25,6) NULL,
  "fin_period_act_cost"  numeric(25,6) NULL,
  "fin_period_bcwp"  numeric(25,6) NULL,
  "fin_period_perfm_work_qty"  numeric(22,6) NULL,
  "fin_period_eac"  numeric(25,6) NULL,
  "fin_period_eac_work_qty"  numeric(22,6) NULL,
  "fin_period_bcws"  numeric(25,6) NULL,
  "fin_period_sched_work_qty"  numeric(22,6) NULL
  )


go
print 'Creating table SUMTRSRC'

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE
CREATE TABLE SUMTRSRC(
  "sumtrsrc_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "wbs_id"  integer NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  varchar(20) NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "remain_start_date"  datetime NULL,
  "remain_end_date"  datetime NULL,
  "overalloc_date"  datetime NULL,
  "staffed_act_qty"  numeric(23,6) NULL,
  "unstaffed_act_qty"  numeric(23,6) NULL,
  "staffed_act_cost"  numeric(23,6) NULL,
  "unstaffed_act_cost"  numeric(23,6) NULL,
  "staffed_act_ot_qty"  numeric(23,6) NULL,
  "unstaffed_act_ot_qty"  numeric(23,6) NULL,
  "staffed_act_ot_cost"  numeric(23,6) NULL,
  "unstaffed_act_ot_cost"  numeric(23,6) NULL,
  "staffed_act_reg_cost"  numeric(23,6) NULL,
  "unstaffed_act_reg_cost"  numeric(23,6) NULL,
  "staffed_act_reg_qty"  numeric(23,6) NULL,
  "unstaffed_act_reg_qty"  numeric(23,6) NULL,
  "staffed_late_remain_qty"  numeric(23,6) NULL,
  "unstaffed_late_remain_qty"  numeric(23,6) NULL,
  "staffed_late_remain_cost"  numeric(23,6) NULL,
  "unstaffed_late_remain_cost"  numeric(23,6) NULL,
  "staffed_remain_qty"  numeric(23,6) NULL,
  "unstaffed_remain_qty"  numeric(23,6) NULL,
  "staffed_remain_cost"  numeric(23,6) NULL,
  "unstaffed_remain_cost"  numeric(23,6) NULL,
  "staffed_target_qty"  numeric(23,6) NULL,
  "unstaffed_target_qty"  numeric(23,6) NULL,
  "staffed_target_cost"  numeric(23,6) NULL,
  "unstaffed_target_cost"  numeric(23,6) NULL,
  "staffed_total_qty"  numeric(23,6) NULL,
  "unstaffed_total_qty"  numeric(23,6) NULL,
  "staffed_total_cost"  numeric(23,6) NULL,
  "unstaffed_total_cost"  numeric(23,6) NULL,
  "fin_period_act_qty"  numeric(23,6) NULL,
  "fin_period_act_cost"  numeric(23,6) NULL,
  "fin_period_total_qty"  numeric(23,6) NULL,
  "fin_period_total_cost"  numeric(23,6) NULL
,CONSTRAINT pk_sumtrsrc PRIMARY KEY (sumtrsrc_id)  )


go
print 'Creating table TASKRISK'

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE
CREATE TABLE TASKRISK(
  "task_id"  integer NOT NULL,
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_risk_task PRIMARY KEY (risk_id,task_id)  )


go
print 'Creating table USER_ACCEPTANCE_CONSENT'

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE
CREATE TABLE USER_ACCEPTANCE_CONSENT(
  "user_id"  integer NOT NULL,
  "status"  integer NULL,
  "modified_date"  datetime DEFAULT getDate() NULL,
  "consent_type"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_user_acceptance_consent PRIMARY KEY (user_id,consent_type)  )


go
--METADATA NAME:color TYPE:FIELD TABLE_NAME:ACTVCODE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('ACTVCODE') and column_name=upper('color');
if @col_exist = 0
ALTER TABLE ACTVCODE 
  add   "color"  varchar(6) NULL
go

--METADATA NAME:rsrc_private TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('rsrc_private');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "rsrc_private"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA NAME:day_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('day_hr_cnt');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "day_hr_cnt"  numeric(10,2) NULL
go

--METADATA NAME:week_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('week_hr_cnt');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "week_hr_cnt"  numeric(10,2) NULL
go

--METADATA NAME:year_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('year_hr_cnt');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "year_hr_cnt"  numeric(10,2) NULL
go

--METADATA NAME:month_hr_cnt TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('CALENDAR') and column_name=upper('month_hr_cnt');
if @col_exist = 0
ALTER TABLE CALENDAR 
  add   "month_hr_cnt"  numeric(10,2) NULL
go

--METADATA NAME:parent_actv_code_id TYPE:FIELD TABLE_NAME:DLTACTV CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('DLTACTV') and column_name=upper('parent_actv_code_id');
if @col_exist = 0
ALTER TABLE DLTACTV 
  add   "parent_actv_code_id"  integer NULL
go

--METADATA NAME:rpt_id TYPE:FIELD TABLE_NAME:FILTPROP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('FILTPROP') and column_name=upper('rpt_id');
if @col_exist = 0
ALTER TABLE FILTPROP 
  add   "rpt_id"  integer NULL
go

--METADATA NAME:parent_job_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('JOBSVC') and column_name=upper('parent_job_id');
if @col_exist = 0
ALTER TABLE JOBSVC 
  add   "parent_job_id"  integer NULL
go

--METADATA NAME:old_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PKXREF') and column_name=upper('old_str');
if @col_exist = 0
ALTER TABLE PKXREF 
  add   "old_str"  varchar(40) NULL
go

--METADATA NAME:new_str TYPE:FIELD TABLE_NAME:PKXREF CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PKXREF') and column_name=upper('new_str');
if @col_exist = 0
ALTER TABLE PKXREF 
  add   "new_str"  varchar(40) NULL
go

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
if @col_exist = 0
ALTER TABLE PREFER 
  add   "ts_rsrc_def_asgn_out_actv_flag"  varchar(1) DEFAULT 'Y' with values  NOT NULL
go

--METADATA NAME:prof_descr TYPE:FIELD TABLE_NAME:PROFILE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROFILE') and column_name=upper('prof_descr');
if @col_exist = 0
ALTER TABLE PROFILE 
  add   "prof_descr"  varchar(255) NULL
go

--METADATA NAME:apply_actuals_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('apply_actuals_date');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "apply_actuals_date"  datetime NULL
go

--METADATA  TYPE:ADHOC_SQL
update usereng set named_user_flag='Y', update_date=getdate(), update_user=session_user where named_user_flag='N'
go

--METADATA NAME:description TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('description');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "description"  varchar(500) NULL
go

--METADATA NAME:intg_proj_type TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('intg_proj_type');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "intg_proj_type"  varchar(7) NULL
go

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,157,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=157)
go

--METADATA NAME:matrix_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('matrix_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "matrix_id"  integer NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "location_id"  integer NULL
go

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('control_updates_flag');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "control_updates_flag"  varchar(1) DEFAULT 'N' with values  NOT NULL
go

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,169,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=169)
go

--METADATA NAME:hist_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('hist_interval');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "hist_interval"  varchar(25) DEFAULT 'Month' with values  NOT NULL
go

--METADATA NAME:hist_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJECT') and column_name=upper('hist_level');
if @col_exist = 0
ALTER TABLE PROJECT 
  add   "hist_level"  varchar(10) DEFAULT 'HL_None' with values  NOT NULL
go

--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_to_type');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_to_type"  varchar(12) DEFAULT 'RT_Threat' with values  NOT NULL
go

--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('identified_by_id');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "identified_by_id"  integer NULL
go

--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('response_type');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "response_type"  varchar(12) NULL
go

--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('response_text');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "response_text"  varchar(255) NULL
go

--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_prblty"  varchar(2) NULL
go

--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_schd_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_schd_prblty"  varchar(2) NULL
go

--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('pre_rsp_cost_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "pre_rsp_cost_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_schd_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_schd_prblty"  varchar(2) NULL
go

--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('post_rsp_cost_prblty');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "post_rsp_cost_prblty"  varchar(2) NULL
go

--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_cause');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_cause"  varchar(4000) NULL
go

--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_effect');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_effect"  varchar(4000) NULL
go

--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('notes');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "notes"  varchar(4000) NULL
go

--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_code');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_code"  varchar(40) DEFAULT 0 with values  NOT NULL
go

--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJRISK') and column_name=upper('risk_desc');
if @col_exist = 0
ALTER TABLE PROJRISK 
  add   "risk_desc"  varchar(4000) NULL
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJWBS') and column_name=upper('intg_type');
if @col_exist = 0
ALTER TABLE PROJWBS 
  add   "intg_type"  varchar(100) NULL
go

--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('PROJWBS') and column_name=upper('status_reviewer');
if @col_exist = 0
ALTER TABLE PROJWBS 
  add   "status_reviewer"  integer NULL
go

--METADATA NAME:parent_risk_type_id TYPE:FIELD TABLE_NAME:RISKTYPE CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RISKTYPE') and column_name=upper('parent_risk_type_id');
if @col_exist = 0
ALTER TABLE RISKTYPE 
  add   "parent_risk_type_id"  integer NULL
go

--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:RPT CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RPT') and column_name=upper('user_id');
if @col_exist = 0
ALTER TABLE RPT 
  add   "user_id"  integer NULL
go

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RSRC') and column_name=upper('intg_type');
if @col_exist = 0
ALTER TABLE RSRC 
  add   "intg_type"  varchar(100) NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('RSRC') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE RSRC 
  add   "location_id"  integer NULL
go

--METADATA NAME:refrdel_project_bypass TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('SPIDMAP') and column_name=upper('refrdel_project_bypass');
if @col_exist = 0
ALTER TABLE SPIDMAP 
  add   "refrdel_project_bypass"  integer NULL
go

--METADATA NAME:location_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASK') and column_name=upper('location_id');
if @col_exist = 0
ALTER TABLE TASK 
  add   "location_id"  integer NULL
go

--METADATA NAME:control_updates_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASK') and column_name=upper('control_updates_flag');
if @col_exist = 0
ALTER TABLE TASK 
  add   "control_updates_flag"  varchar(1) DEFAULT 'N' with values  NULL
go

--METADATA NAME:prior_ts_act_reg_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_reg_qty');
if @col_exist = 0
ALTER TABLE TASKRSRC 
  add   "prior_ts_act_reg_qty"  numeric(17,6) NULL
go

--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag, update_date, update_user) select prof_id,156,case p.allow_flag when 'Y' then 'Y' else 'N' END, getdate(),session_user from profpriv p where priv_num=29  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=156)
go

--METADATA NAME:prior_ts_act_ot_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKRSRC') and column_name=upper('prior_ts_act_ot_qty');
if @col_exist = 0
ALTER TABLE TASKRSRC 
  add   "prior_ts_act_ot_qty"  numeric(17,6) NULL
go

--METADATA NAME:late_remain_work_qty TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_work_qty');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_work_qty"  numeric(22,6) NULL
go

--METADATA  TYPE:ADHOC_SQL
delete from usereng where db_engine_type='PA'
go

--METADATA NAME:late_remain_work_cost TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_work_cost');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_work_cost"  numeric(25,6) NULL
go

--METADATA NAME:late_remain_equip_cost TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_equip_cost');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_equip_cost"  numeric(25,6) NULL
go

--METADATA NAME:late_remain_equip_qty TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_equip_qty');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_equip_qty"  numeric(22,6) NULL
go

--METADATA NAME:late_remain_cost TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_cost');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_cost"  numeric(23,6) NULL
go

--METADATA NAME:late_remain_mat_cost TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_mat_cost');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_mat_cost"  numeric(25,6) NULL
go

--METADATA NAME:late_remain_expense_cost TYPE:FIELD TABLE_NAME:TASKSUMFIN CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('TASKSUMFIN') and column_name=upper('late_remain_expense_cost');
if @col_exist = 0
ALTER TABLE TASKSUMFIN 
  add   "late_remain_expense_cost"  numeric(25,6) NULL
go

--METADATA NAME:cr_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('USERS') and column_name=upper('cr_user_name');
if @col_exist = 0
ALTER TABLE USERS 
  add   "cr_user_name"  varchar(255) NULL
go

--METADATA NAME:userset_blob TYPE:FIELD TABLE_NAME:USERSET CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('USERSET') and column_name=upper('userset_blob');
if @col_exist = 0
ALTER TABLE USERSET 
  add   "userset_blob"  TEXT NULL
go

--METADATA NAME:view_pref_value_blob TYPE:FIELD TABLE_NAME:VWPREFDATA CHANGE:CREATE
declare @col_exist int
select @col_exist=count(*) from INFORMATION_SCHEMA.COLUMNS where table_name = upper('VWPREFDATA') and column_name=upper('view_pref_value_blob');
if @col_exist = 0
ALTER TABLE VWPREFDATA 
  add   "view_pref_value_blob"  TEXT NULL
go

print 'Creating constraint fk_discussion_task on table DISCUSSION'


--METADATA NAME:fk_discussion_task TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
ADD CONSTRAINT fk_discussion_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_discussion_read_users on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_users TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_discussion_read_discussion on table DISCUSSION_READ'


--METADATA NAME:fk_discussion_read_discussion TYPE:CONSTRAINT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
ALTER TABLE DISCUSSION_READ
ADD CONSTRAINT fk_discussion_read_discussion FOREIGN KEY (discussion_id)
REFERENCES DISCUSSION (discussion_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_docreview_document on table DOCREVIEW'


--METADATA NAME:fk_docreview_document TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_document FOREIGN KEY (doc_id)
REFERENCES DOCUMENT (doc_id) 
go

print 'Creating constraint fk_docreview_users on table DOCREVIEW'


--METADATA NAME:fk_docreview_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEW CHANGE:CREATE
ALTER TABLE DOCREVIEW
ADD CONSTRAINT fk_docreview_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_docreviewtask_docreview on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_docreview TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_docreview FOREIGN KEY (doc_review_id)
REFERENCES DOCREVIEW (doc_review_id) 
go

print 'Creating constraint fk_docreviewtask_users on table DOCREVIEWTASK'


--METADATA NAME:fk_docreviewtask_users TYPE:CONSTRAINT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
ALTER TABLE DOCREVIEWTASK
ADD CONSTRAINT fk_docreviewtask_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_filtprop_rpt on table FILTPROP'


--METADATA NAME:fk_filtprop_rpt TYPE:CONSTRAINT TABLE_NAME:FILTPROP CHANGE:CREATE
ALTER TABLE FILTPROP
ADD CONSTRAINT fk_filtprop_rpt FOREIGN KEY (rpt_id)
REFERENCES RPT (rpt_id) 
go

print 'Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
go

print 'Creating constraint fk_pfoliouser_users on table PFOLIOUSER'


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_rpt_users on table RPT'


--METADATA NAME:fk_rpt_users TYPE:CONSTRAINT TABLE_NAME:RPT CHANGE:CREATE
ALTER TABLE RPT
ADD CONSTRAINT fk_rpt_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go

print 'Creating constraint fk_sumprojcost_project on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_project TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_projwbs on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumprojcost_costtype on table SUMPROJCOST'


--METADATA NAME:fk_sumprojcost_costtype TYPE:CONSTRAINT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
ALTER TABLE SUMPROJCOST
ADD CONSTRAINT fk_sumprojcost_costtype FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_project on table SUMTASK'


--METADATA NAME:fk_sumtask_project TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtask_projwbs on table SUMTASK'


--METADATA NAME:fk_sumtask_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASK CHANGE:CREATE
ALTER TABLE SUMTASK
ADD CONSTRAINT fk_sumtask_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_project on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_project TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtaskspread_projwbs on table SUMTASKSPREAD'


--METADATA NAME:fk_sumtaskspread_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
ALTER TABLE SUMTASKSPREAD
ADD CONSTRAINT fk_sumtaskspread_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_project on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_project TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_sumtrsrc_projwbs on table SUMTRSRC'


--METADATA NAME:fk_sumtrsrc_projwbs TYPE:CONSTRAINT TABLE_NAME:SUMTRSRC CHANGE:CREATE
ALTER TABLE SUMTRSRC
ADD CONSTRAINT fk_sumtrsrc_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_risk_riskid on table TASKRISK'


--METADATA NAME:fk_risk_riskid TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_riskid FOREIGN KEY (risk_id)
REFERENCES PROJRISK (risk_id) 
go

print 'Creating constraint fk_risk_task on table TASKRISK'


--METADATA NAME:fk_risk_task TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_risk_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go

print 'Creating constraint fk_taskrisk_project on table TASKRISK'


--METADATA NAME:fk_taskrisk_project TYPE:CONSTRAINT TABLE_NAME:TASKRISK CHANGE:CREATE
ALTER TABLE TASKRISK
ADD CONSTRAINT fk_taskrisk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
go

print 'Creating constraint fk_user_acpt_consent_users on table USER_ACCEPTANCE_CONSENT'


--METADATA NAME:fk_user_acpt_consent_users TYPE:CONSTRAINT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
ALTER TABLE USER_ACCEPTANCE_CONSENT
ADD CONSTRAINT fk_user_acpt_consent_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id)  ON DELETE CASCADE 
go
 
--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER
ALTER TABLE BUDGCHNG ALTER COLUMN chng_by_name varchar(255)
go
 
--METADATA NAME:chng_by_name TYPE:FIELD TABLE_NAME:BUDGCHNG CHANGE:ALTER 
--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER
ALTER TABLE CALENDAR ALTER COLUMN clndr_name varchar(255) NOT NULL 
go
 
--METADATA NAME:clndr_name TYPE:FIELD TABLE_NAME:CALENDAR CHANGE:ALTER 
--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN author_name varchar(255)
go
 
--METADATA NAME:author_name TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:cr_external_doc_key TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER
ALTER TABLE DOCUMENT ALTER COLUMN cr_external_doc_key varchar(4000)
go
 
--METADATA NAME:cr_external_doc_key TYPE:FIELD TABLE_NAME:DOCUMENT CHANGE:ALTER 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC ALTER COLUMN job_name varchar(255) NOT NULL 
go
 
--METADATA NAME:job_name TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER
ALTER TABLE NOTE ALTER COLUMN user_name varchar(255) NOT NULL 
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:NOTE CHANGE:ALTER 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE ALTER COLUMN proj_catg_type varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL ALTER COLUMN proj_catg_short_name varchar(60) NOT NULL 
go
 
--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT ALTER COLUMN prm_user_name varchar(255)
go
 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER
ALTER TABLE PRMAUDIT ALTER COLUMN netaddress varchar(64)
go
 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:ALTER 
--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN enqueue_user varchar(255)
go
 
--METADATA NAME:enqueue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN sender_name varchar(255)
go
 
--METADATA NAME:sender_name TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER
ALTER TABLE PRMQUEUE ALTER COLUMN dequeue_user varchar(255)
go
 
--METADATA NAME:dequeue_user TYPE:FIELD TABLE_NAME:PRMQUEUE CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT ALTER COLUMN add_by_name varchar(255)
go
 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER
ALTER TABLE PROJECT ALTER COLUMN cr_external_key varchar(4000)
go
 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:PROJECT CHANGE:ALTER 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER
ALTER TABLE PROJISSU ALTER COLUMN add_by_name varchar(255)
go
 
--METADATA NAME:add_by_name TYPE:FIELD TABLE_NAME:PROJISSU CHANGE:ALTER 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN add_date datetime NULL
go
 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN risk_name varchar(200) NOT NULL 
go
 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER 
--METADATA NAME:load_status TYPE:FIELD TABLE_NAME:PROJSHAR CHANGE:ALTER 
--METADATA NAME:load_status TYPE:FIELD TABLE_NAME:PROJSHAR CHANGE:ALTER 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS ALTER COLUMN est_wt numeric(10,2) NULL
go
 
--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER
ALTER TABLE PUBUSER ALTER COLUMN private_db_user_name varchar(255) NOT NULL 
go
 
--METADATA NAME:private_db_user_name TYPE:FIELD TABLE_NAME:PUBUSER CHANGE:ALTER 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN rsrc_short_name varchar(255) NOT NULL 
go
 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN rsrc_name varchar(255) NOT NULL 
go
 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER
ALTER TABLE SPIDMAP ALTER COLUMN user_name varchar(255)
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:ALTER 
--METADATA NAME:est_wt TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
ALTER TABLE TASK ALTER COLUMN est_wt numeric(10,2) NULL
go
 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:TASK CHANGE:ALTER
 
declare @default sysname, @sql nvarchar(max)

select @default = name
from sys.default_constraints
where parent_object_id = object_id('TASK')
AND type = 'D'
AND parent_column_id = (
    select column_id
    from sys.columns
    where object_id = object_id('TASK')
    and name = 'review_type'
    )

set @sql = N'alter table TASK drop constraint ' + @default
print @sql
exec sp_executesql @sql
 
ALTER TABLE TASK ADD DEFAULT ('RV_OK') FOR [review_type] 
go
 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:TASKWKSP CHANGE:ALTER
ALTER TABLE TASKWKSP ALTER COLUMN cr_external_key varchar(4000)
go
 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:TASKWKSP CHANGE:ALTER 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN rsrc_short_name varchar(255)
go
 
--METADATA NAME:rsrc_short_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN rsrc_name varchar(255)
go
 
--METADATA NAME:rsrc_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER
ALTER TABLE TSAUDIT ALTER COLUMN user_name varchar(255)
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:TSAUDIT CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER
ALTER TABLE UEVNTREG ALTER COLUMN user_name varchar(255)
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:UEVNTREG CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN user_name varchar(255) NOT NULL 
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN actual_name varchar(255)
go
 
--METADATA NAME:actual_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN cr_external_key varchar(4000)
go
 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD ALTER COLUMN user_name varchar(255)
go
 
--METADATA NAME:user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER
ALTER TABLE USESSAUD ALTER COLUMN os_user_name varchar(255)
go
 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSAUD CHANGE:ALTER 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER
ALTER TABLE USESSION ALTER COLUMN os_user_name varchar(255)
go
 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:USESSION CHANGE:ALTER 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:WORKSPACE CHANGE:ALTER
ALTER TABLE WORKSPACE ALTER COLUMN cr_external_key varchar(4000)
go
 
--METADATA NAME:cr_external_key TYPE:FIELD TABLE_NAME:WORKSPACE CHANGE:ALTER
print 'Creating index ndx_discussion_1 on table DISCUSSION'

--METADATA NAME:ndx_discussion_1 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_1
ON DISCUSSION (task_id,discussion_date)

go

print 'Creating index ndx_discussion_2 on table DISCUSSION'

--METADATA NAME:ndx_discussion_2 TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_2
ON DISCUSSION (user_id,discussion_date)

go

print 'Creating index ndx_discussion_dsi on table DISCUSSION'

--METADATA NAME:ndx_discussion_dsi TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE
CREATE  INDEX ndx_discussion_dsi
ON DISCUSSION (delete_session_id,delete_date)

go

print 'Creating index ndx_discussion_read_dsi on table DISCUSSION_READ'

--METADATA NAME:ndx_discussion_read_dsi TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
CREATE  INDEX ndx_discussion_read_dsi
ON DISCUSSION_READ (delete_session_id,delete_date)

go

print 'Creating index ndx_docreview_document on table DOCREVIEW'

--METADATA NAME:ndx_docreview_document TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_document
ON DOCREVIEW (doc_id)

go

print 'Creating index ndx_docreview_users on table DOCREVIEW'

--METADATA NAME:ndx_docreview_users TYPE:INDEX TABLE_NAME:DOCREVIEW CHANGE:CREATE
CREATE  INDEX ndx_docreview_users
ON DOCREVIEW (user_id)

go

print 'Creating index ndx_docreviewtask_docreview on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_docreview TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_docreview
ON DOCREVIEWTASK (doc_review_id)

go

print 'Creating index ndx_docreviewtask_users on table DOCREVIEWTASK'

--METADATA NAME:ndx_docreviewtask_users TYPE:INDEX TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
CREATE  INDEX ndx_docreviewtask_users
ON DOCREVIEWTASK (user_id)

go

print 'Creating index ndx_imagedata_image_name on table IMAGEDATA'

--METADATA NAME:ndx_imagedata_image_name TYPE:INDEX TABLE_NAME:IMAGEDATA CHANGE:CREATE
CREATE UNIQUE  INDEX ndx_imagedata_image_name
ON IMAGEDATA (image_name)

go

print 'Creating index ndx_project_last_fin_dates on table PROJECT'

--METADATA NAME:ndx_project_last_fin_dates TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_last_fin_dates
ON PROJECT (last_fin_dates_id)

go

print 'Creating index ndx_project_matrix on table PROJECT'

--METADATA NAME:ndx_project_matrix TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE
CREATE  INDEX ndx_project_matrix
ON PROJECT (matrix_id)

go

print 'Creating index ndx_rsrc_unit on table RSRC'

--METADATA NAME:ndx_rsrc_unit TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_unit
ON RSRC (unit_id)

go

print 'Creating index ndx_rsrc_curr on table RSRC'

--METADATA NAME:ndx_rsrc_curr TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE
CREATE  INDEX ndx_rsrc_curr
ON RSRC (curr_id)

go

print 'Creating index ndx_rsrchour_ts_rsrc on table RSRCHOUR'

--METADATA NAME:ndx_rsrchour_ts_rsrc TYPE:INDEX TABLE_NAME:RSRCHOUR CHANGE:CREATE
CREATE  INDEX ndx_rsrchour_ts_rsrc
ON RSRCHOUR (ts_id,rsrc_id)

go

print 'Creating index ndx_sumprojcost_wbs on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_wbs TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_wbs
ON SUMPROJCOST (wbs_id)

go

print 'Creating index ndx_sumprojcost_cost_type on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_cost_type TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_cost_type
ON SUMPROJCOST (cost_type_id)

go

print 'Creating index ndx_sumprojcost_proj on table SUMPROJCOST'

--METADATA NAME:ndx_sumprojcost_proj TYPE:INDEX TABLE_NAME:SUMPROJCOST CHANGE:CREATE
CREATE  INDEX ndx_sumprojcost_proj
ON SUMPROJCOST (proj_id)

go

print 'Creating index ndx_sumtask_proj on table SUMTASK'

--METADATA NAME:ndx_sumtask_proj TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_proj
ON SUMTASK (proj_id)

go

print 'Creating index ndx_sumtask_wbs on table SUMTASK'

--METADATA NAME:ndx_sumtask_wbs TYPE:INDEX TABLE_NAME:SUMTASK CHANGE:CREATE
CREATE  INDEX ndx_sumtask_wbs
ON SUMTASK (wbs_id)

go

print 'Creating index ndx_sumtaskspread_proj on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_proj TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_proj
ON SUMTASKSPREAD (proj_id)

go

print 'Creating index ndx_sumtaskspread_wbs on table SUMTASKSPREAD'

--METADATA NAME:ndx_sumtaskspread_wbs TYPE:INDEX TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
CREATE  INDEX ndx_sumtaskspread_wbs
ON SUMTASKSPREAD (wbs_id)

go

print 'Creating index ndx_sumtrsrc_project on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_project TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_project
ON SUMTRSRC (proj_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_projwbs on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projwbs TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projwbs
ON SUMTRSRC (wbs_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_rsrcrole on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_rsrcrole TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_rsrcrole
ON SUMTRSRC (rsrc_id,role_id,spread_type)

go

print 'Creating index ndx_sumtrsrc_projrsrcrole_id on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_projrsrcrole_id TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE
CREATE  INDEX ndx_sumtrsrc_projrsrcrole_id
ON SUMTRSRC (proj_id,rsrc_id,role_id)

go

print 'Creating index ndx_taskrisk_risk on table TASKRISK'

--METADATA NAME:ndx_taskrisk_risk TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_risk
ON TASKRISK (risk_id)

go

print 'Creating index ndx_taskrisk_proj on table TASKRISK'

--METADATA NAME:ndx_taskrisk_proj TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_proj
ON TASKRISK (proj_id)

go

print 'Creating index ndx_taskrisk_task on table TASKRISK'

--METADATA NAME:ndx_taskrisk_task TYPE:INDEX TABLE_NAME:TASKRISK CHANGE:CREATE
CREATE  INDEX ndx_taskrisk_task
ON TASKRISK (task_id)

go

print 'Creating index ndx_trsrcsum_role_dialog on table TRSRCSUM'

--METADATA NAME:ndx_trsrcsum_role_dialog TYPE:INDEX TABLE_NAME:TRSRCSUM CHANGE:CREATE
CREATE  INDEX ndx_trsrcsum_role_dialog
ON TRSRCSUM (proj_id,taskrsrc_sum_id,rsrc_id,role_id,skill_level,overalloc_date,delete_session_id)

go

print 'Creating index ndx_users_curr on table USERS'

--METADATA NAME:ndx_users_curr TYPE:INDEX TABLE_NAME:USERS CHANGE:CREATE
CREATE  INDEX ndx_users_curr
ON USERS (curr_id)

go

print 'Creating index ndx_userset_user on table USERSET'

--METADATA NAME:ndx_userset_user TYPE:INDEX TABLE_NAME:USERSET CHANGE:CREATE
CREATE  INDEX ndx_userset_user
ON USERSET (user_id)

go

print 'Creating index ndx_usropnval_user_open_id on table USROPNVAL'

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:CREATE
CREATE  INDEX ndx_usropnval_user_open_id
ON USROPNVAL (user_open_id)

go

print 'Creating index ndx_wbsrsrc_role on table WBSRSRC'

--METADATA NAME:ndx_wbsrsrc_role TYPE:INDEX TABLE_NAME:WBSRSRC CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_role
ON WBSRSRC (role_id)

go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id2 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id2 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id2
ON WBSRSRC_QTY (fin_dates_id2)

go

print 'Creating index ndx_wbsrsrc_qty_fin_dates_id1 on table WBSRSRC_QTY'

--METADATA NAME:ndx_wbsrsrc_qty_fin_dates_id1 TYPE:INDEX TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
CREATE  INDEX ndx_wbsrsrc_qty_fin_dates_id1
ON WBSRSRC_QTY (fin_dates_id1)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DISCUSSION_discussion_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DISCUSSION_discussion_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEW_doc_review_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEW_doc_review_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCREVIEWTASK_review_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCREVIEWTASK_review_task_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('IMAGEDATA_image_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('IMAGEDATA_image_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LOCATION_location_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LOCATION_location_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SUMTRSRC_sumtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SUMTRSRC_sumtrsrc_id')) 
go



--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA 
DECLARE @vpid int
DECLARE vpdata CURSOR FOR
  select DISTINCT view_pref_id 
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
  or    upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType');
OPEN vpdata
FETCH NEXT FROM vpdata INTO @vpid
WHILE @@Fetch_Status = 0
   BEGIN
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select top 1 @vpid view_pref_id, 'VT_ACTIVITY.BarDisplayTypes' view_pref_key, 'NORMAL_BAR' view_pref_value
from VWPREFDATA 
where view_pref_id = @vpid
and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes') and view_pref_id = @vpid)

update VWPREFDATA
set view_pref_value = (select view_pref_value
   from VWPREFDATA
   where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.FirstBarDisplayType'))
   + 
   case upper(IsNull((select view_pref_value
       from VWPREFDATA
       where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType')
      ), ''))
   when 'NO_BAR' then ''
   when '' then ''
   when 'BASELINE_BAR' then ','+ 'PRIMARY_BASELINE_BAR'
   else ',' + upper(IsNull((select view_pref_value
      from VWPREFDATA
      where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType')
      ), '')) 
   end
where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes')

delete from VWPREFDATA 
where view_pref_id = @vpid 
and   (upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
    or    
       upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType')
      )

FETCH NEXT FROM vpdata INTO @vpid             
END
CLOSE vpdata
DEALLOCATE vpdata
go

begin
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProject','Y' from viewpref where view_pref_type='VT_UIVIEW'; 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProjectSeq','5' from viewpref where view_pref_type='VT_UIVIEW' ;
end
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_CALENDAR 
begin
update  c
set c.DAY_HR_CNT = p.DAY_HR_CNT,c.WEEK_HR_CNT = p.WEEK_HR_CNT,c.MONTH_HR_CNT = p.MONTH_HR_CNT,c.YEAR_HR_CNT = p.YEAR_HR_CNT
from  calendar c ,prefer p;
update prefer set ALLOW_USER_TIME_PERIOD_FLAG = 'N';
end
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_CALENDAR
--METADATA TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS 
declare
@db_version varchar(255);
begin
select @db_version=database_version from prefer;
if substring(@db_version, len ('PMDB,') + 1, 4) >'0600'
 exec drop_background_procs;
delete from settings where namespace='database.background.Damon';
delete from settings where namespace='database.background.Symon';
end;
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG 
declare @dbengtype varchar(10)
declare @vuserid int
declare @vusereng_id int
begin try
create table ##dbenginetype ( dbenginetype char(10) )
insert into ##dbenginetype(dbenginetype) 
select  'PM'
union all select 'TS'
union all select 'WEB_PM'
union all select 'WEB_RM'
union all select 'WU'
union all select 'TS_ONLY'
select @vusereng_id=key_seq_num  from nextkey where key_name='usereng_user_eng_id';
declare usercur cursor for select user_id from users where prof_id=12;
open usercur
fetch usercur into @vuserid
WHILE (@@FETCH_STATUS = 0)
BEGIN 
	declare engtypecur cursor for select dbenginetype from ##dbenginetype
	open engtypecur
	fetch engtypecur into @dbengtype
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        If NOT (select count(*) from usereng where user_id=@vuserid and db_engine_type=@dbengtype) >0
        BEGIN
          insert into usereng(user_eng_id,user_id,db_engine_type) values (@vusereng_id,@vuserid,ltrim(rtrim(@dbengtype)))
          set @vusereng_id=@vusereng_id+1
       END
        fetch engtypecur into @dbengtype
      END
      close  engtypecur
      deallocate  engtypecur
      fetch usercur into @vuserid
END
close usercur
deallocate usercur
update nextkey set key_seq_num=@vusereng_id where key_name='usereng_user_eng_id';  
drop table ##dbenginetype
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG
--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare @vprefid integer,@max_view_pref_id integer,@vpid int,@pos int
declare vpdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.Filter')  and upper(view_pref_value) like upper('CustomFilter');
BEGIN
select @vprefid=key_seq_num  from nextkey where key_name='viewpref_view_pref_id';
  select @max_view_pref_id=max(view_pref_id)   from viewpref;
  if (@vprefid<=@max_view_pref_id ) 
   set  @vprefid=@max_view_pref_id+1
  open vpdata
FETCH NEXT FROM vpdata INTO @vpid
WHILE @@Fetch_Status = 0
   BEGIN
insert into viewpref(view_pref_id,view_pref_name,view_pref_type,user_id) select @vprefid,view_pref_name,'VT_FILTER',user_id from viewpref where view_pref_id=@vpid  ;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select @vprefid, 'VT_FILTER.FilterCriteria', view_pref_value
from VWPREFDATA
where view_pref_id = @vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria') and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_FILTER.FilterCriteria') and view_pref_id = @vprefid)
insert into vwprefuser(view_pref_id,user_id) select @vprefid,user_id from vwprefuser where view_pref_id=@vpid;
UPDATE VWPREFDATA SET VIEW_PREF_VALUE = 'TreeFilter' WHERE VIEW_PREF_KEY = 'VT_ACTIVITY.Filter' AND VIEW_PREF_ID =@vpid;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value) values(@vpid,'VT_ACTIVITY.FiltersList',@vprefid) --from vwprefdata where not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.FiltersList') and view_pref_id = @vpid)
delete from VWPREFDATA where view_pref_id=@vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria');
set @vprefid=@vprefid+1;
FETCH NEXT FROM vpdata INTO @vpid             
END
CLOSE vpdata
DEALLOCATE vpdata
update nextkey set key_seq_num=@vprefid where key_name='viewpref_view_pref_id';
declare vpfilterdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_FILTER.FilterCriteria') 
  open vpfilterdata
  FETCH NEXT FROM vpfilterdata INTO @vpid
  WHILE (@@FETCH_STATUS =0)
  BEGIN
     set @pos=0
     select @pos=charindex('UDF:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid
     if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'UDF:','UDF_') where view_pref_id=@vpid
     select @pos=charindex('ActivityCodeTypeId:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid	
      if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'ActivityCodeTypeId:','ActivityCodeTypeId_') where view_pref_id=@vpid
  FETCH NEXT FROM vpfilterdata INTO @vpid                 	
  END
CLOSE vpfilterdata
DEALLOCATE vpfilterdata
END
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare vwcur cursor local for select view_pref_id from viewpref  where view_pref_type='VT_UIVIEW' 
declare @view_pref_id int
begin try
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,case p.prof_id when 12 then 'Y' else 'N' end,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
open vwcur
fetch vwcur into @view_pref_id
WHILE (@@FETCH_STATUS = 0)
BEGIN 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProject','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProjectSeq','6')
fetch vwcur into @view_pref_id
END
close vwcur
deallocate vwcur
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
Declare @earnedValue integer
Declare @valuePatternAtCompl VARCHAR(30) 
Declare @valuePatternBudgCur VARCHAR(30) 
Declare @valuePatternBudg VARCHAR(30)
 
Declare @insertValueAtCompl VARCHAR(30)
Declare @insertValueBudgCur VARCHAR(30)
Declare @insertValueBudg    VARCHAR(30)
Declare @settingsName VARCHAR(30)
Declare @position integer
   begin
	 set @valuePatternAtCompl = '%EV_AtCompl%'
	 set @valuePatternBudgCur = '%EV_Budg_With_Start_Dates%'
	 set @valuePatternBudg = '%EV_Budg%'

	 set @insertValueAtCompl = 'EV_AtCompl'
	 set @insertValueBudgCur = 'EV_BudgCur'
	 set @insertValueBudg    = 'EV_Budg'
     set @settingsName= 'EVCalculation'
	 set @earnedValue=0
     
	 select @earnedValue=1 from settings where setting_name='EVCalculation';
	 if @earnedValue=0
	 begin
		select @position=patindex(@valuePatternAtCompl,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			insert into settings(namespace, setting_name, setting_value) 
			values('Administrator_Settings', @settingsName, @insertValueAtCompl);
			return
        end
		select @position=patindex(@valuePatternBudgCur,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			 insert into settings(namespace, setting_name, setting_value) 
			 values('Administrator_Settings', @settingsName, @insertValueBudgCur);
			 return
        end
		select @position=patindex(@valuePatternBudg,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			  insert into settings(namespace, setting_name, setting_value) 
			  values('Administrator_Settings', @settingsName, @insertValueBudg);
			  return
        end
     end
	end

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
Declare @valuePattern VARCHAR(30) 
 
Declare @position integer
begin
	 set @valuePattern = '%pvurl%'

   UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines'
	 select @position=patindex(@valuePattern, config_data) from admin_config where config_name='CS_ADMIN'
		if @position>0
        begin
			insert into settings(namespace, setting_name) 
			values('Administrator_Settings', 'WebAccessURL')
			return
        end

   UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
   UPDATE project set msp_managed_flag = 'N',sum_only_flag = 'N' where msp_managed_flag != 'N' or sum_only_flag != 'N';
end

go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160); 

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , getdate(), session_user from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end


go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=getdate(),update_user=session_user WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0 );
end
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
declare @vprefid integer
begin
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 

  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'MyActivities','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
end;

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=view_pref_value+1,update_date=getdate()  where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and view_pref_value>='1'
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 

DECLARE cur_notfin_vpid CURSOR FOR
  SELECT view_pref_id
  FROM   vwprefdata
  WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
         AND view_pref_value = 'NotFinishedActivitiesOnly'
DECLARE @v_id_list VARCHAR(100),
        @v_pref_id INT
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
     and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select *
                    from vwprefdata vw
                    where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                       and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
  select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
     
    SELECT @v_id_list = CAST(Min(view_pref_id) AS varchar(30)) + ',' + CAST(Max(view_pref_id) AS varchar(30))
    FROM   viewpref
    WHERE  view_pref_name IN ( 'InProgressActivitiesOnly',
                               'NotStartedActivitiesOnly' );
    OPEN cur_notfin_vpid
    FETCH next FROM cur_notfin_vpid INTO @v_pref_id
    WHILE ( @@FETCH_STATUS = 0 )
      BEGIN
          UPDATE vwprefdata
          SET    view_pref_value = 'TreeFilter'
          WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
                 AND view_pref_id = @v_pref_id;

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersList',
                      @v_id_list);

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersOperator',
                      'OR');

          FETCH next FROM cur_notfin_vpid INTO @v_pref_id
      END

    CLOSE cur_notfin_vpid
    DEALLOCATE cur_notfin_vpid     
end;


go 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE from usereng
where db_engine_type ='TS'
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS');
go

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END,getdate(),session_user from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
BEGIN
BEGIN TRY
  create table #temprisk (risk_id integer,notes varchar(4000))
  insert into #temprisk select p.risk_id,substring('Applies to WBS-'+ Pw.Wbs_name+char(10) +'Applies to Resource-'+isnull(r.rsrc_name,'')+char(10)+'Responsible Manager-'+isnull(o.obs_name,'')+char(10)
+ 'Priority-'+ isnull(P.Priority_type,'')+char(10) + 'Date Identified-'+ isnull(CONVERT(varchar(20) , p.add_date, 100),'')+char(10)+'Impact Date-'+isnull(CONVERT(varchar(20) , p.impact_date, 100),'')+char(10)+ 'Probability-' +isnull(str(p.prbly_pct),'') + char(10)+'Impact - Labor Units-'+isnull(str(p.impact_work_qty),'')+ char(10)+'Impact - Nonlabor Units-'+isnull(str(p.impact_equip_qty),'') +char(10)+'Impact - Material Units-'+isnull(str(p.impact_mat_qty),'') + char(10) +'Impact - Expenses-'+ isnull(str(p.impact_expense_cost),'')+  char(10)+substring(rc.risk_control,1,2000),1,4000) From  Projrisk P Left outer join Riskctrl rc on p.risk_id=rc.risk_id left outer join projwbs pw on p.wbs_id=pw.wbs_id  Left Outer Join Obs O On P.Obs_id=O.Obs_id Left Outer Join  Rsrc R On P.Rsrc_id=R.Rsrc_id 
   update PROJRISK set notes=#temprisk.notes,risk_code='PROJRISK-'+ltrim(str(projrisk.risk_id)),risk_desc=SUBSTRING(risk_descr,1,4000),status_code=CASE status_code when 'RS_Closed' then 'RS_Manage' else status_code end from #temprisk where #temprisk.risk_id=projrisk.risk_id
   drop table #temprisk
END TRY
BEGIN CATCH
   DECLARE @ErrorMessage NVARCHAR(4000),  @ErrorSeverity integer, @ErrorState integer, @ErrorNumber integer;
   SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE()
               ,@ErrorNumber = ERROR_NUMBER() ;
   RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState );
END CATCH  
END
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK 
--METADATA NAME:wbs_id TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='wbs_id'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  wbs_id
go
 
--METADATA NAME:priority_type TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='priority_type'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  priority_type
go
 
--METADATA NAME:obs_id TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='obs_id'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  obs_id
go
 
--METADATA NAME:prbly_pct TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='prbly_pct'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  prbly_pct
go
 
--METADATA NAME:impact_work_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_work_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_work_qty
go
 
--METADATA NAME:impact_equip_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_equip_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_equip_qty
go
 
--METADATA NAME:impact_expense_cost TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_expense_cost'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_expense_cost
go
 
--METADATA NAME:impact_date TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_date'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_date
go
 
--METADATA NAME:impact_mat_qty TYPE:EXEC
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='impact_mat_qty'
 if @default_name is not null
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
ALTER TABLE PROJRISK drop column  impact_mat_qty
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:ALTER_PROJRISK
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

INSERT INTO SETTINGS (namespace,setting_name,setting_value) VALUES('Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/');
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
declare @vpropid integer
begin
  exec pc_get_next_key 'viewprop_view_id', @vpropid OUTPUT;
  insert into viewprop (VIEW_ID,VIEW_NAME,VIEW_TYPE)
  select @vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
  where not exists ( select view_id from viewprop where VIEW_NAME='Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ; 
  end;
go


go 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
DECLARE RiskCursor CURSOR LOCAL FOR SELECT risk_id, risk_desc from PROJRISK
OPEN RiskCursor
DECLARE @riskID INT, @HTMLText VARCHAR(4000), @Start INT, @End INT, @Length INT
FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText
WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @Start = CHARINDEX('<',@HTMLText)
	SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
	SET @Length = (@End - @Start) + 1
	WHILE @Start > 0 AND @End > 0 AND @Length > 0
    BEGIN
        SET @HTMLText = STUFF(@HTMLText,@Start,@Length,'')
        SET @Start = CHARINDEX('<',@HTMLText)
        SET @End = CHARINDEX('>',@HTMLText,CHARINDEX('<',@HTMLText))
        SET @Length = (@End - @Start) + 1
    END
    SET @HTMLText = REPLACE(@HTMLText, '&amp;', '&')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp;', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&nbsp', ' ')
	SET @HTMLText = REPLACE(@HTMLText, '&lt;', '<')
	SET @HTMLText = REPLACE(@HTMLText, '&gt;', '>')
	SET @HTMLText = REPLACE(@HTMLText, char(13) , ' ')
	SET @HTMLText = REPLACE(@HTMLText, char(10) , '')
	SET @HTMLText = LTRIM(RTRIM(@HTMLText))
	UPDATE PROJRISK SET risk_desc = @HTMLText where risk_id = @riskID 
	FETCH NEXT FROM RiskCursor INTO @riskID, @HTMLText 
END
CLOSE RiskCursor
DEALLOCATE RiskCursor
GO
go 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Administrator_Settings', 'AlwaysLaunchOnlineHelp',
'Y' from settings where not exists ( select 1 from settings where namespace='Administrator_Settings' and setting_name =
'AlwaysLaunchOnlineHelp' )
end
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
go


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set  setting_value='http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name='OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select ue1.user_id from usereng ue1
where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM')
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'VIS')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go
go 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION_DEL' and type in ('TR'))
  DROP TRIGGER RT_USESSION_DEL
go

--METADATA  TYPE:SSCR NAME:RT_USESSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION' and type in ('TR'))
  DROP TRIGGER RT_USESSION
go

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_USESSION
on USESSION
for update,insert
as     
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;

update USESSION
set update_date = getdate()    
, update_user = @user_name
, create_user =  case @del_cnt WHEN 0 then @user_name else USESSION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else USESSION.create_date end
from inserted 
where USESSION.session_id = inserted.session_id
go
go 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
 --METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
go
go 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
update prefer set license_data=null
go
go 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
insert into PROFPRIV (prof_id,priv_num,allow_flag)
select DISTINCT a.PROF_ID,177,'Y' from PROFPRIV a
where not exists ( select 1 from PROFPRIV b where b.PROF_ID=a.PROF_ID and b.priv_num=177 and b.allow_flag='Y') 
go

go 
--END TYPE:UP2 GROUP:1803to1804 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=177;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=177;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=177;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'N');
  end
FETCH NEXT FROM @profile_cur INTO @v_prof_id
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

go 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
go

go 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv 
where prof_id in
(select pp.prof_id from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
and priv_num in
(select pp.priv_num from profile p , profpriv pp
 where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project'
)
go

--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
go

