
--Run Script as     
SET DEFINE OFF

prompt Creating table PFOLIOUSER

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE
CREATE TABLE PFOLIOUSER(
  pfolio_id  number(10) NOT NULL,
  user_id  number(10) NOT NULL,
  update_date  DATE NULL,
  update_user  varchar2(255 CHAR) NULL,
  create_date  DATE NULL,
  create_user  varchar2(255 CHAR) NULL,
  delete_session_id  number(10) NULL,
  delete_date  DATE NULL
,CONSTRAINT pk_pfoliouser PRIMARY KEY (pfolio_id,user_id)  )
TABLESPACE PMDB_DAT1
    STORAGE (INITIAL 1M NEXT 1M MAXEXTENTS UNLIMITED PCTINCREASE 0)

/
--METADATA NAME:image_extension TYPE:FIELD TABLE_NAME:IMAGEDATA CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('image_extension');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE IMAGEDATA add   image_extension  varchar2(20 CHAR) DEFAULT ''png'' NOT NULL
';
  end if;
END;         
/

--METADATA NAME:ts_rsrc_def_asgn_out_actv_flag TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
DECLARE
  col_exists integer;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('PREFER') and column_name=upper('ts_rsrc_def_asgn_out_actv_flag');
  if col_exists = 0
  then
    execute immediate 'ALTER TABLE PREFER add   ts_rsrc_def_asgn_out_actv_flag  varchar2(1 CHAR) DEFAULT ''Y'' NOT NULL
';
  end if;
END;         
/

prompt Creating constraint fk_pfoliouser_pfolio on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_pfolio TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_pfolio FOREIGN KEY (pfolio_id)
REFERENCES PFOLIO (pfolio_id) 
/

prompt Creating constraint fk_pfoliouser_users on table PFOLIOUSER


--METADATA NAME:fk_pfoliouser_users TYPE:CONSTRAINT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
ALTER TABLE PFOLIOUSER
ADD CONSTRAINT fk_pfoliouser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
/

--METADATA NAME:proj_catg_type TYPE:FIELD TABLE_NAME:PCATTYPE CHANGE:ALTER
ALTER TABLE PCATTYPE modify proj_catg_type varchar2(60 CHAR)
/

--METADATA NAME:proj_catg_short_name TYPE:FIELD TABLE_NAME:PCATVAL CHANGE:ALTER
ALTER TABLE PCATVAL modify proj_catg_short_name varchar2(60 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:ALTER
ALTER TABLE PROJWBS modify intg_type varchar2(100 CHAR)
/

--METADATA NAME:intg_type TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC modify intg_type varchar2(100 CHAR)
/



--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
/
/ 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
---METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
/
/ 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
/
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/

--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
/


/ 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  col_exists integer;
  cursor cur is select IMAGE_NAME ,image_id from IMAGEDATA;
BEGIN
  select count(*) into col_exists from user_tab_columns where table_name = upper('IMAGEDATA') and column_name=upper('Image_Extension');
  if col_exists > 0 then
   for i in cur loop 
    begin
      if instr(i.image_name,'.')>0 then
      execute immediate 'update imagedata
        set image_name = :1,
            image_extension = :2
      where image_id=:3' using SUBSTR(i.image_name,1,INSTR(i.image_name,'.',-1,1)-1),SUBSTR(i.image_name,INSTR(i.image_name,'.',-1,1)+1),i.image_id;  
      end if;
    exception when others then
      null;
    end;
   end loop;
  end if;
 END;
 /
 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
delete from profpriv pp
where exists
(select p.prof_id from profile p 
where p.prof_id = pp.prof_id and pp.priv_num=177
and p.scope_type = 'ST_Project')
/




/ 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
DECLARE
v_len number;
v_start_point number;
v_final blob;
cursor c is select issue_id,issue_notes 
from projissu where issue_notes is NOT NULL ;
begin
for rec in c loop
v_len := dbms_lob.getlength(rec.issue_notes);
if(v_len is not null and v_len > 0) then
v_start_point:=dbms_lob.instr(rec.issue_notes, utl_raw.cast_to_raw('DOCTYPE'));
if (v_start_point=0 or v_start_point is null) then
  dbms_lob.createtemporary(v_final, true);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'));
  dbms_lob.append(v_final, rec.issue_notes);
  dbms_lob.append(v_final,utl_raw.cast_to_raw('</SPAN></BODY></HTML>'));
  execute immediate 'update projissu set issue_notes = :1 where issue_id= :2' using v_final,rec.issue_id;
commit;
end if;
end if;
end loop;
dbms_lob.freetemporary(v_final);
dbms_lob.close(v_final);
EXCEPTION
 WHEN OTHERS THEN
  NULL;
end;
/
/ 
--END TYPE:UP2 GROUP:1912to19121 NAME:MISC_UPDATES
update prefer set database_version='PPMDB,1912.0006.0000.0000'
/
commit
/