prompt Creating users ADMUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:ADMUSER
create user admuser
       identified by admuser
       temporary tablespace temp
       default   tablespace pmdb_dat1
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:ADMUSER
grant create session,create table,create sequence,create procedure,create trigger,create type,create view to admuser
/

--METADATA TYPE:GRANT OBJECT:DBMS_REPUTIL PRIVILEGE GRANTEE:SYSTEM
GRANT EXECUTE ON sys.DBMS_REPUTIL TO admuser
/

--METADATA TYPE:GRANT OBJECT:DBMS_JOB PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_JOB TO admuser
/

--METADATA TYPE:GRANT OBJECT:DBMS_LOB PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_LOB TO admuser
/

--METADATA TYPE:GRANT OBJECT:DBMS_SQL PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_SQL TO admuser
/

--METADATA TYPE:GRANT OBJECT:DBMS_RANDOM PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON sys.DBMS_RANDOM TO admuser
/

--METADATA TYPE:GRANT OBJECT:TRANSACTION PRIVILEGE GRANTEE:ADMUSER
GRANT SELECT ON sys.v_$transaction TO admuser
/

GRANT SELECT ON sys.gv_$transaction TO admuser
/
--METADATA TYPE:GRANT OBJECT:CTX_DDL PRIVILEGE GRANTEE:ADMUSER
GRANT EXECUTE ON ctxsys.CTX_DDL TO admuser
/
    
--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_DAT1
alter user admuser quota unlimited on PMDB_DAT1
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_NDX1
alter user admuser quota unlimited on PMDB_NDX1
/

--METADATA TYPE:GRANT CHANGE:GRANT NAME:PMDB_LOB1
alter user admuser quota unlimited on PMDB_LOB1
/

--alter user admuser quota unlimited on PMDB_PX_DAT1
--/-- Removed as there is no PMDB_PX_DAT1 tbs

prompt Creating users PRIVUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:PRIVUSER
create user privuser
       identified by privuser
       temporary tablespace temp
       default   tablespace pmdb_dat1
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PRIVUSER
grant create session,create view,create synonym to privuser
/

--METADATA TYPE:GRANT OBJECT:TRANSACTION PRIVILEGE GRANTEE:PRIVUSER
GRANT SELECT ON sys.v_$transaction TO privuser
/

--METADATA TYPE:GRANT OBJECT:CTX_DDL PRIVILEGE GRANTEE:PRIVUSER
GRANT SELECT ON sys.gv_$transaction TO privuser
/

prompt Creating users PUBUSER
--METADATA TYPE:USER CHANGE:CREATE NAME:PUBUSER
create user pubuser
       identified by pubuser
       temporary tablespace temp
       default   tablespace pmdb_dat1
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:PUBUSER
grant create session,create synonym  to pubuser
/

prompt Creating users BGJOBUSER 
--METADATA TYPE:USER CHANGE:CREATE NAME:BGJOBUSER
create user bgjobuser 
       identified by bgjobuser 
       temporary tablespace temp
       default   tablespace pmdb_dat1
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant create session,create job,create synonym  to bgjobuser 
/

--METADATA TYPE:ROLE CHANGE:CREATE ROLE 
declare roleExists integer;
BEGIN
 select count(*) into roleExists from dba_roles where role='PM_BG_JOB_ROLE';
 if (roleExists=0) then
      execute immediate 'create role PM_BG_JOB_ROLE';
 end if;
 end;
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE GRANTEE:BGJOBUSER
grant PM_BG_JOB_ROLE to bgjobuser 
/

--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE:SELECT GRANTEE:PRIVUSER
grant select on sys.dba_extents to admuser,privuser
/
--METADATA TYPE:GRANT CHANGE:CREATE PRIVILEGE:SELECT GRANTEE:PRIVUSER
grant select on sys.dba_views to admuser
/

