-- B script contains all the non-standard tables

/* START: Dynamic Stats tables */

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'PRMAUDIT'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true
                            );
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'PRMAUDIT');                            
end;
/
begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'TSAUDIT'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true
                            );
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'TSAUDIT');                            
end;
/
begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'USESSAUD'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true
                            );
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'USESSAUD');                            
end;
/



/* END: Dynamic Stats tables */

/* USESSION */

begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'USESSION');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'USESSION'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            );
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'USESSION'
                            , numrows=>100
                            , numblks=>8
                            , avgrlen=>122
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'PK_USESSION'
                            , numrows=>100
                            , numlblks=>1
                            , numdist=>100
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_USESSION_SPID'
                            , numrows=>100
                            , numlblks=>1
                            , numdist=>100
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );  
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_USESSION_USERS'
                            , numrows=>100
                            , numlblks=>1
                            , numdist=>25
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_USSESION_DSI'
                            , numrows=>100
                            , numlblks=>1
                            , numdist=>1
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );
end;
/


begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'SESSION_ID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'LAST_ACTIVE_TIME'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'LOGIN_TIME'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'USER_ID'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.02
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'HOST_NAME'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.02
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'APP_NAME'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.02
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'DB_ENGINE_TYPE'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.02
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'HARD_DRIVE_CODE'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.02
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'VDB_INSTANCE_GUID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>22
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'SPID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'UPDATE_USER'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.04
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'CREATE_DATE'
                            , distcnt=>25
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.04
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'USESSION'
                            , colname=>'DELETE_SESSION_ID'
                            , distcnt=>1
                            , nullcnt=>90
                            , avgclen=>2
                            , density=>0.01
                            );
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'USESSION');
end;
/


/* PROJSHAR */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'PROJSHAR');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'PROJSHAR'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'PROJSHAR'
                            , numrows=>1000
                            , numblks=>50
                            , avgrlen=>16
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'PK_PROJSHAR'
                            , numrows=>1000
                            , numlblks=>1
                            , numdist=>1000
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_PROJSHAR_USESSION'
                            , numrows=>1000
                            , numlblks=>1
                            , numdist=>1000
                            , clstfct=>1
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>0
                            );
end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PROJSHAR'
                            , colname=>'PROJ_ID'
                            , distcnt=>500
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.002
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PROJSHAR'
                            , colname=>'SESSION_ID'
                            , distcnt=>500
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.002
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PROJSHAR'
                            , colname=>'ACCESS_LEVEL'
                            , distcnt=>4
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.25
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PROJSHAR'
                            , colname=>'LOAD_STATUS'
                            , distcnt=>2
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.5
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'PROJSHAR');
end;
/

/* REFRDEL */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'REFRDEL');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'REFRDEL'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , numrows=>10000000
                            , numblks=>90000
                            , avgrlen=>36
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_REFRDEL_TABLE_PK'
                            , numrows=>10000000
                            , numlblks=>90000
                            , numdist=>10000000
                            , clstfct=>70000
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_REFRDEL_DELETE_DATE'
                            , numrows=>10000000
                            , numlblks=>45000
                            , numdist=>5000
                            , clstfct=>45000
                            , avglblk=>7
                            , avgdblk=>35
                            , indlevel=>2
                            );
end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'DELETE_DATE'
                            , distcnt=>5000
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.0002
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'TABLE_NAME'
                            , distcnt=>250
                            , nullcnt=>0
                            , avgclen=>9
                            , density=>0.004
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'PK1'
                            , distcnt=>1000000
                            , nullcnt=>0
                            , avgclen=>7
                            , density=>0.000001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'PK2'
                            , distcnt=>250000
                            , nullcnt=>1000000
                            , avgclen=>7
                            , density=>0.000004
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'PK3'
                            , distcnt=>100
                            , nullcnt=>9500000
                            , avgclen=>2
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'PK4'
                            , distcnt=>0
                            , nullcnt=>10000000
                            , avgclen=>0
                            , density=>0
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'REFRDEL'
                            , colname=>'PROJ_ID'
                            , distcnt=>10000
                            , nullcnt=>100000
                            , avgclen=>5
                            , density=>0.0001
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'REFRDEL');
end;
/

/* UPKLIST */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'UPKLIST');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'UPKLIST'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'UPKLIST'
                            , numrows=>1000000
                            , numblks=>9000
                            , avgrlen=>15
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_UPKLIST_SESSION_PK'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>1000000
                            , clstfct=>9000
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );

end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UPKLIST'
                            , colname=>'SESSION_ID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UPKLIST'
                            , colname=>'CONTEXT_ID'
                            , distcnt=>10
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.1
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UPKLIST'
                            , colname=>'PK_ID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UPKLIST'
                            , colname=>'PK2_ID'
                            , distcnt=>100
                            , nullcnt=>500000
                            , avgclen=>5
                            , density=>0.01
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'UPKLIST');
end;
/

/* PKXREF */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'PKXREF');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'PKXREF'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , numrows=>1000000
                            , numblks=>9000
                            , avgrlen=>36
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_PKXREF_1'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>1000000
                            , clstfct=>9000
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_PKXREF_2'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>7000
                            , clstfct=>9000
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );

end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'SYSTEM_ID'
                            , distcnt=>100
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.01
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'CONTEXT_NAME'
                            , distcnt=>5
                            , nullcnt=>0
                            , avgclen=>15
                            , density=>0.2
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'PK1'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'OLD_PK1'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0001
                            );
 dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'PK2'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PKXREF'
                            , colname=>'OLD_PK2'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0001
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'PKXREF');
end;
/


/* UACCESS */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'UACCESS');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'UACCESS'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , numrows=>1000000
                            , numblks=>4000
                            , avgrlen=>22
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_UACCESS_PROJECT'
                            , numrows=>1000000
                            , numlblks=>2400
                            , numdist=>10000
                            , clstfct=>100000
                            , avglblk=>1
                            , avgdblk=>19
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_UACCESS_USER_PARENT'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>10000
                            , clstfct=>2500
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_UACCESS_USER_WBS'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>1000000
                            , clstfct=>2500
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'PK_UACCESS'
                            , numrows=>1000000
                            , numlblks=>500
                            , numdist=>1000000
                            , clstfct=>2500
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );

end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , colname=>'USER_ID'
                            , distcnt=>2000
                            , nullcnt=>0
                            , avgclen=>4
                            , density=>0.0005
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , colname=>'PROJ_ID'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>5
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , colname=>'ACCESS_FLAG'
                            , distcnt=>2
                            , nullcnt=>0
                            , avgclen=>2
                            , density=>0.5
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , colname=>'WBS_ID'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'UACCESS'
                            , colname=>'PARENT_WBS_ID'
                            , distcnt=>2000
                            , nullcnt=>0
                            , avgclen=>6
                            , density=>0.0005
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'UACCESS');
end;
/

/* PRMQUEUE */
begin
  dbms_stats.unlock_table_stats( ownname=>user
                            , tabname=>'PRMQUEUE');
end;
/

begin
  dbms_stats.delete_table_stats(  ownname=>user
                            , tabname=>'PRMQUEUE'
                            , cascade_columns=>true
                            , cascade_indexes=>true
                            , force=>true);
end;
/


begin
  dbms_stats.set_table_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , numrows=>10000000
                            , numblks=>200000
                            , avgrlen=>133
                            );
end;
/

begin
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'PK_PRMQUEUE'
                            , numrows=>10000000
                            , numlblks=>100000
                            , numdist=>10000000
                            , clstfct=>600000
                            , avglblk=>1
                            , avgdblk=>1
                            , indlevel=>2
                            );
  dbms_stats.set_index_stats( ownname=>user
                            , indname=>'NDX_PRMQUEUE_LOOKUP'
                            , numrows=>10000000
                            , numlblks=>50000
                            , numdist=>2
                            , clstfct=>200000
                            , avglblk=>8000
                            , avgdblk=>34000
                            , indlevel=>2
                            );

end;
/

begin
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'QUEUE_NAME'
                            , distcnt=>1
                            , nullcnt=>0
                            , avgclen=>17
                            , density=>1
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'MSG_KEY'
                            , distcnt=>10000000
                            , nullcnt=>0
                            , avgclen=>33
                            , density=>0.0000001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'ENQUEUE_DATE'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'DEQUEUE_DATE'
                            , distcnt=>10000
                            , nullcnt=>0
                            , avgclen=>8
                            , density=>0.0001
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'MSG_TYPE'
                            , distcnt=>2
                            , nullcnt=>0
                            , avgclen=>7
                            , density=>0.5
                            );
  dbms_stats.set_column_stats( ownname=>user
                            , tabname=>'PRMQUEUE'
                            , colname=>'MSG_SUB_TYPE'
                            , distcnt=>2
                            , nullcnt=>0
                            , avgclen=>7
                            , density=>0.5
                            );
                            
end;
/

begin
  dbms_stats.lock_table_stats( ownname=>user
                            , tabname=>'PRMQUEUE');
end;
/
