@echo off
setlocal
REM --------------------------------------------------------------------------------------------------------------------
REM Run the Primavera Project Manager Database Configuration Tool
REM --------------------------------------------------------------------------------------------------------------------

SET JAR_FILE_DIR=lib
SET JAR_FILE_NAME=dbmt.jar

SET JVM_PROPERTIES=-Xms256m -Xmx1024m -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner -Duser.region=US
SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.dbschema.package.location=%JAR_FILE_DIR% -Dcom.primavera.database.logfile=DatabaseSetup.log -Dprimavera.bootstrap.home=.
SET DBMT_ACTION=application/installppm
SET DBMT_COMMAND=installppm
IF NOT EXIST "%JAVA_HOME%\bin\java.exe" (
 echo JAVA_HOME IS NOT SET
 pause
 goto :EXIT
) 

SET PATH="%JAVA_HOME%\bin";%PATH%;

if "" == "%*" goto :NOARGS

SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.application.runner=com.primavera.database.tools.dbmt.cmd.CmdLineApplicationRunner
java %JVM_PROPERTIES% -cp %JAR_FILE_DIR%\dbmt.jar;%JAR_FILE_DIR%\dbtools.jar;%JAR_FILE_DIR%\ojdbc.jar com.primavera.database.tools.dbmt.PrepScriptRunner %*
java %JVM_PROPERTIES% -jar %JAR_FILE_DIR%\%JAR_FILE_NAME% %DBMT_COMMAND%  %*

IF %ERRORLEVEL% NEQ 0 (
  echo DBError: DBSetup failed to complete! Returned error level: %ERRORLEVEL% 
)

IF %ERRORLEVEL% EQU 0 (
  echo DBSetup completed successfully. Returned error level: %ERRORLEVEL% 
)

goto :EXIT

:NOARGS
SET JVM_PROPERTIES=%JVM_PROPERTIES% -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner
START javaw %JVM_PROPERTIES% -jar %JAR_FILE_DIR%\%JAR_FILE_NAME% %DBMT_ACTION%
:EXIT

exit %ERRORLEVEL%
