#!/bin/sh

if [ -z "$JAVA_HOME" ] ; then
  echo "\$JAVA_HOME is not set"
  exit
fi

JAR_FILE_DIR=lib
JAR_FILE_NAME=dbmt.jar

JVM_PROPERTIES="-Ddbmt.dbschema.package.location=$JAR_FILE_DIR"

# To use the Motif look and feel, comment the MetalLookAndFeel line and uncomment the MotifLookAndFeel property.
# To use the default system look and feel, Comment both of the following lines.
JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=javax.swing.plaf.metal.MetalLookAndFeel -Dcom.primavera.database.logfile=SchemaValidation.log -Dprimavera.bootstrap.home=."
# JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.ui.class.lookandfeel=com.sun.java.swing.plaf.motif.MotifLookAndFeel"

MAIN_APPLICATION=com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDatabaseLogins

JVM_PROPERTIES="$JVM_PROPERTIES -Ddbmt.application.runner=com.primavera.database.tools.dbmt.gui.ActionApplicationRunner"
$JAVA_HOME/bin/java $JVM_PROPERTIES -classpath "$JAR_FILE_DIR/$JAR_FILE_NAME:$JAR_FILE_DIR/commons-lang.jar" $MAIN_APPLICATION "$@"
