/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.actions.nodes;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionLogicTreeNode;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.RootNodeAdapter;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionPathable;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ActionNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ActionSetNode;
import com.primavera.database.tools.dbmt.xml.util.actions.nodes.ImportNode;
import org.xml.sax.Attributes;

public class ContextNode
extends RootNodeAdapter
implements ActionContainer,
ActionPathable {
    private final String m_type;
    private final ActionLogicManager m_manager;

    public ContextNode(Attributes attr, ActionLogicManager manager) {
        super("context");
        this.m_type = this.getSimpleClassName(attr.getValue("type"));
        this.m_manager = manager;
    }

    private String getSimpleClassName(String fullClassName) {
        try {
            Class<?> cls = Class.forName(fullClassName);
            return cls.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            DBMTLogger.error(Channel.DEV, "Class not found: " + fullClassName);
            return Object.class.getSimpleName();
        }
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("actionset".equals(elemName)) {
            return new ActionSetNode(this, attr);
        }
        if ("action".equals(elemName)) {
            return new ActionNode(this, attr);
        }
        if ("import".equals(elemName)) {
            return new ImportNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public void addAction(String id, ActionOperation action) {
        this.m_manager.getRoot().addActionLogic(id, action);
    }

    @Override
    public ActionLogicTreeNode addActionSet(String id) {
        return this.m_manager.getRoot().addNode(id);
    }

    @Override
    public ActionLogicManager getActionManager() {
        return this.m_manager;
    }

    @Override
    public Iterable<ActionOperation> getActions() {
        return this.m_manager.getRoot().getActionMap().values();
    }

    @Override
    public Iterable<ActionLogicTreeNode> getActionSets() {
        return this.m_manager.getRoot().getActionSetMap().values();
    }

    @Override
    public String getPropertyRoot() {
        return "action." + this.m_type;
    }

    @Override
    public String path() {
        return "/" + this.getElemName();
    }

    @Override
    public String getActionPath() {
        return "";
    }
}

