/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.schemaval.CompareFileSaveJob;
import com.primavera.database.tools.dbmt.schemaval.SchemaBuilderJob;
import com.primavera.database.tools.dbmt.schemaval.SchemaValidationReportLaunchJob;
import com.primavera.database.tools.dbmt.schemaval.SchemaValidationTransformJob;

public class ValidateJob
extends AbstractJob {
    private final String m_connectTargetString;
    private final String m_privilegedUser;
    private final String m_publicUser;
    private final String m_pxrptUser;
    private final ProductSuiteType m_productType;

    public ValidateJob(String connectString, String privuser, String pubuser, String pxrptuser, ProductSuiteType productType) {
        this.m_connectTargetString = connectString;
        this.m_privilegedUser = privuser;
        this.m_publicUser = pubuser;
        this.m_pxrptUser = pxrptuser;
        this.m_productType = productType;
        DBMTLogger.info(Channel.DEV, "Validate: Target = " + this.m_connectTargetString);
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        DBMTLogger.info(Channel.DEV, "Validate: Target = " + this.m_connectTargetString);
        new SchemaBuilderJob(this.m_connectTargetString).doJob(listener, watcher);
        new CompareFileSaveJob().doJob(listener, watcher);
        new SchemaValidationTransformJob(this.m_connectTargetString, this.m_privilegedUser, this.m_publicUser, this.m_pxrptUser, this.m_productType, "migrate").doJob(listener, watcher);
        new SchemaValidationReportLaunchJob().doJob(listener, watcher);
        return true;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    public String toString() {
        return "Validate the schema migration";
    }
}

