/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.util.DBMTUtil;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class GrantRevokeJob
extends AbstractJob {
    private JobProperties m_jobProperties;
    private String m_connectString = null;
    private final String m_type;

    public GrantRevokeJob(JobProperties jobProps, String type) {
        this.m_jobProperties = jobProps;
        try {
            this.m_connectString = this.m_jobProperties.getConnection(ConnectionClass.SYSADMIN);
        }
        catch (ConnectionNotFoundException e) {
            DBMTLogger.warn(e.getMessage());
        }
        this.m_type = type;
        DBMTLogger.info(Channel.DEV, "Validate: Target = " + this.m_connectString);
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        if (this.m_type.equals("grant")) {
            DBMTLogger.info(Channel.DEV, "Granting Privilege To Administrator: Target = " + this.m_connectString);
            String adminUser = this.m_jobProperties.getScriptProperties().get("pm.or.administrative_user").toString();
            DBMTUtil.grantDBAToAdmUser(this.m_connectString, adminUser);
            String privUser = this.m_jobProperties.getScriptProperties().get("pm.or.privileged_user").toString();
            DBMTUtil.grantDBAExtents(this.m_connectString, adminUser, privUser);
        } else if (this.m_type.equals("grant_and_create_pxrpt")) {
            DBMTLogger.info(Channel.DEV, "Granting Privilege To Administrator: Target = " + this.m_connectString);
            String adminUser = this.m_jobProperties.getScriptProperties().get("pm.or.administrative_user").toString();
            DBMTUtil.grantDBAToAdmUser(this.m_connectString, adminUser);
            String defaultDatafileLocation = this.getDefaultDatafileLocation(this.m_connectString);
            String tablespaceBaseName = "PMDB";
            HashSet<String> availableTablespaces = new HashSet<String>();
            availableTablespaces.addAll(TablespaceUtil.getAvailableTablespaces(this.m_connectString).keySet());
            String pxTbsName = this.m_jobProperties.getScriptProperties().getProperty("pm.px_tablespace").toString();
            String pxPath = defaultDatafileLocation + pxTbsName + ".DBF";
            String pxrptUser = this.m_jobProperties.getScriptProperties().get("pm.or.odsplus_user").toString();
            String pxrptPass = this.m_jobProperties.getScriptProperties().get("pm.or.odsplus_password").toString();
            String checkPxTbsName = GrantRevokeJob.findTablespaceName(availableTablespaces, pxTbsName);
            DBMTUtil.createPxrptUser(this.m_connectString, pxTbsName, pxPath, adminUser, pxrptUser, pxrptPass, checkPxTbsName);
        } else if (this.m_type.equals("grant_priv_pxrpt")) {
            DBMTLogger.info(Channel.DEV, "Creating PXRPTUSER: Target = " + this.m_connectString);
            String adminUser = this.m_jobProperties.getScriptProperties().get("pm.or.administrative_user").toString();
            String privUser = this.m_jobProperties.getScriptProperties().get("pm.or.privileged_user").toString();
            String pxrptUser = this.m_jobProperties.getScriptProperties().get("pm.or.odsplus_user").toString();
            DBMTUtil.privPxrptUser(this.m_connectString, adminUser, privUser, pxrptUser);
        } else if (this.m_type.equals("revoke")) {
            DBMTLogger.info(Channel.DEV, "Finishing schema Migration: Target = " + this.m_connectString);
            String adminUser = this.m_jobProperties.getScriptProperties().get("pm.or.administrative_user").toString();
            DBMTUtil.revokeDBAFromAdmUser(this.m_connectString, adminUser);
            String pmdat = this.m_jobProperties.getScriptProperties().getProperty("pm.data_tablespace").toString();
            String pmlob = this.m_jobProperties.getScriptProperties().getProperty("pm.lob_tablespace").toString();
            String pmndx = this.m_jobProperties.getScriptProperties().getProperty("pm.index_tablespace").toString();
            DBMTUtil.grantUnlimitedTbs(this.m_connectString, adminUser, pmdat, pmlob, pmndx);
        } else if (this.m_type.equals("revoke_and_drop_pxrpt")) {
            DBMTLogger.info(Channel.DEV, "Finishing schema Migration: Target = " + this.m_connectString);
            String pxrptUser = this.m_jobProperties.getScriptProperties().get("pm.or.odsplus_user").toString();
            String pxrptTablespace = this.m_jobProperties.getScriptProperties().get("pm.or.px_path").toString();
            pxrptTablespace = pxrptTablespace.substring(pxrptTablespace.lastIndexOf(47) + 1, pxrptTablespace.lastIndexOf(46));
            DBMTUtil.removePxrptUser(this.m_connectString, pxrptUser, pxrptTablespace);
            String adminUser = this.m_jobProperties.getScriptProperties().get("pm.or.administrative_user").toString();
            String privUser = this.m_jobProperties.getScriptProperties().get("pm.or.privileged_user").toString();
            DBMTUtil.grantPriv(this.m_connectString, adminUser, privUser);
            DBMTUtil.revokeDBAFromAdmUser(this.m_connectString, adminUser);
        } else if (this.m_type.equals("SS_priv_pxrpt")) {
            DBMTLogger.info(Channel.DEV, "Creating PXRPTUSER: Target = " + this.m_connectString);
            String privUser = this.m_jobProperties.getScriptProperties().get("pm.ss.privileged_user").toString();
            String pxrptUser = this.m_jobProperties.getScriptProperties().get("pm.ss.odsplus_user").toString();
            this.m_connectString = this.m_jobProperties.getConnection(ConnectionClass.SYSUSER);
            DBMTUtil.ssPrivPxrptUser(this.m_connectString, privUser, pxrptUser);
        } else if (this.m_type.equals("ss_drop_pxrpt")) {
            DBMTLogger.info(Channel.DEV, "Finishing schema Migration: Target = " + this.m_connectString);
            String pxrptUser = this.m_jobProperties.getScriptProperties().get("pm.ss.odsplus_user").toString();
            this.m_connectString = this.m_jobProperties.getConnection(ConnectionClass.SYSUSER);
            DBMTUtil.ssRemovePxrptUser(this.m_connectString, pxrptUser);
        }
        return true;
    }

    private static String findTablespaceName(Set<String> availableTablespaces, String currentTablespaceBaseName) {
        String checkFlag = "false";
        if (availableTablespaces.contains(currentTablespaceBaseName)) {
            checkFlag = "true";
        }
        return checkFlag;
    }

    private String getDefaultDatafileLocation(String connectString) {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectString);
            String string = OracleLogic.getDefaultDirectory(connection);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    public String toString() {
        if (this.m_type.equals("grant_and_create_pxrpt")) {
            return "Creating Report User";
        }
        if (this.m_type.equals("grant_priv_pxrpt")) {
            return "Granting Privilege To Private User";
        }
        if (this.m_type.startsWith("grant")) {
            return "Granting Privilege To Administrator";
        }
        return "Finishing schema Migration";
    }
}

