/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.workflow.DatapumpJob;
import com.primavera.database.tools.dbmt.workflow.ScriptStringValue;
import java.util.Properties;

public class DatapumpJobFactory
implements ParameterizedJobFactory<DatapumpJob> {
    private final ScriptStringValue m_name;
    private final ConnectionClass m_class;

    public DatapumpJobFactory(ScriptStringValue name, ConnectionClass connectionClass) {
        this.m_name = name;
        this.m_class = connectionClass;
    }

    @Override
    public DatapumpJob createJob(JobProperties props) throws ValueNotFound, ConnectionNotFoundException {
        Properties jobProps = props.cloneJobProperties();
        String connectString = props.getConnection(this.m_class);
        int commitRows = 512;
        try {
            commitRows = Integer.parseInt((String)props.getJobProperty("dataloader.commit.rows"));
        }
        catch (JobPropertyNotFound jobPropertyNotFound) {
            // empty catch block
        }
        String dataSource = this.m_name.getValue(jobProps);
        props.setJobProperty(InstallSuiteOptionKeys.SAMPLE_DATA_SOURCE, dataSource);
        return new DatapumpJob(dataSource, connectString, commitRows);
    }
}

