/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedDatabaseJobFactory;
import com.primavera.database.tools.dbmt.workflow.JavaCallJob;
import java.util.ArrayList;
import java.util.List;

public class CallJobFactory
extends ParameterizedDatabaseJobFactory<JavaCallJob> {
    private final String m_className;
    private final String m_methodName;
    private final String m_descriptionKey;
    private final List<String> m_parameters = new ArrayList<String>();

    public CallJobFactory(ConnectionClass connectionClass, ActionClass actionClass, SchemaInfo schema, String className, String methodName, String descriptionKey, List<String> parameters) {
        super(connectionClass);
        this.m_className = className;
        this.m_methodName = methodName;
        this.m_descriptionKey = descriptionKey;
        this.m_parameters.addAll(parameters);
    }

    @Override
    public JavaCallJob createJob(JobProperties props, String connectString) throws ValueNotFound {
        ArrayList<Object> paramObjects = new ArrayList<Object>();
        for (String key : this.m_parameters) {
            try {
                DBMTLogger.info(Channel.DEV, "Adding parameter " + key + " = " + props.getJobProperty(key));
                paramObjects.add(props.getJobProperty(key));
            }
            catch (JobPropertyNotFound e) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.javacall.paramnotfound", new String[]{this.m_descriptionKey, this.m_className, this.m_methodName, key}));
                paramObjects.add(null);
            }
        }
        return new JavaCallJob(connectString, this.m_className, this.m_methodName, this.m_descriptionKey, paramObjects);
    }
}

