/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins.ui;

import com.primavera.PhoenixException;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginsTableModel;
import com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDabaseLoginsModel;
import com.primavera.database.tools.dbmt.updatelogins.ui.ComponentPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.NavigationOperation;
import com.primavera.database.tools.dbmt.updatelogins.ui.PanelIdentifier;
import com.primavera.database.tools.dbmt.updatelogins.ui.UnableToPopulatePrivateLoginsTable;
import com.primavera.database.tools.dbmt.updatelogins.ui.UpdatePrivateDatabaseLoginsUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

@PanelIdentifier(value="page.logins")
public class LoginTablePanel
extends ComponentPanel
implements PrivateDatabaseLoginsTableModel.PrivateDatabaseLoginsTableModelListener {
    private static final String UPDATE_REENCRYPTED_PASSWORD_SQL = "UPDATE pubuser SET private_db_passwd = ? where public_group_id = ?";
    private static Color COLOR_BG_SELECTED = UIManager.getColor("EditorPane.selectionBackground");
    private static Color COLOR_FG_SELECTED = UIManager.getColor("EditorPane.selectionForeground");
    private static Color COLOR_BG_UNSELECTED = UIManager.getColor("Table.background");
    private static Color COLOR_FG_UNSELECTED = UIManager.getColor("Table.foreground");
    private static final String FIELD_PASS = "PASS";
    private static final String FIELD_NAME = "NAME";
    private static final String FIELD_ID = "ID";
    private static final String SQL_STMT_SELECT_FROM_PUBUSER = "SELECT public_group_id ID, private_db_user_name NAME, private_db_passwd PASS FROM PUBUSER";
    private final JViewport m_viewport = new JViewport();
    private final JTable m_table = new JTable();
    private final JButton m_btnAdd = new JButton(new AddButtonAction());
    private final JButton m_btnDel = new JButton(new DeleteButtonAction());
    private final JButton m_btnSet = new JButton(new SetPasswordButtonAction());
    private final JPasswordField m_pwdPassword = new JPasswordField();
    private String m_originalPassword = null;
    private boolean m_passwordAltered = false;

    public LoginTablePanel(UpdatePrivateDabaseLoginsModel m, UpdatePrivateDatabaseLoginsUI ui) {
        super(m, ui);
    }

    private static final void setCellFormatting(JLabel label, boolean isSelected) {
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        label.setOpaque(true);
        label.setBackground(isSelected ? COLOR_BG_SELECTED : COLOR_BG_UNSELECTED);
        label.setForeground(isSelected ? COLOR_FG_SELECTED : COLOR_FG_UNSELECTED);
    }

    @Override
    public void initialize() {
        this.m_table.setModel(this.model.getTableModel());
        this.m_table.setRowHeight(20);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.m_viewport.add(this.m_table);
        this.m_table.getColumnModel().getColumn(0).setCellRenderer(new GroupIdRenderer());
        this.m_table.getColumnModel().getColumn(0).setCellEditor(new GroupIdTableCellEditor(new JTextField()));
        this.m_table.getColumnModel().getColumn(0).setMaxWidth(100);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.m_table.getColumnModel().getColumn(1).setCellRenderer(new UserNameRenderer());
        this.m_table.getColumnModel().getColumn(1).setCellEditor(new UsernameTableCellEditor(new JTextField()));
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
        this.m_table.setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(new LoginTableSelectionListener());
        this.m_table.getSelectionModel().addListSelectionListener(new PasswordFieldEnablerListner());
        this.m_table.setPreferredScrollableViewportSize(new Dimension(640, 280));
        JPanel tablePanel = new JPanel();
        tablePanel.setBorder(BorderFactory.createEtchedBorder(0));
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.m_table.getTableHeader(), "North");
        tablePanel.add((Component)this.m_viewport, "Center");
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new FlowLayout(0));
        leftButtonPanel.add(this.m_btnAdd);
        this.m_btnAdd.setMnemonic(StringLocalizer.get("dbmt.update.private.database.logins.button.add.mnemonic").charAt(0));
        leftButtonPanel.add(this.m_btnDel);
        this.m_btnDel.setMnemonic(StringLocalizer.get("dbmt.update.private.database.logins.button.delete.mnemonic").charAt(0));
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new FlowLayout(2));
        JLabel lblPassword = new JLabel(StringLocalizer.get("dbmt.update.private.database.logins.field.password.label"));
        lblPassword.setLabelFor(this.m_pwdPassword);
        rightButtonPanel.add(lblPassword);
        rightButtonPanel.add(this.m_pwdPassword);
        rightButtonPanel.add(this.m_btnSet);
        this.m_pwdPassword.setColumns(20);
        this.m_pwdPassword.setAction(this.m_btnSet.getAction());
        this.m_pwdPassword.addKeyListener(new PasswordCaretListener());
        this.m_pwdPassword.addMouseListener(new PasswordCaretListener());
        tablePanel.add((Component)rightButtonPanel, "South");
        lowerPanel.add((Component)leftButtonPanel, "West");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)tablePanel, "Center");
        mainPanel.add((Component)lowerPanel, "South");
        this.m_btnAdd.setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
        this.m_btnDel.setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
        this.m_btnSet.setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
        this.m_btnSet.setEnabled(false);
        this.root.add(mainPanel);
    }

    @Override
    public void dataUpdated() {
    }

    @Override
    public void onExit(UpdatePrivateDabaseLoginsModel model) throws DBMTException {
        super.onExit(model);
        model.getTableModel().removeListener(this);
    }

    @Override
    public void onUndo(UpdatePrivateDabaseLoginsModel model) {
        super.onUndo(model);
        model.getTableModel().removeListener(this);
    }

    @Override
    public void onEnter(UpdatePrivateDabaseLoginsModel m_model) throws DBMTException {
        m_model.getTableModel().addListener(this);
        HashMap<Integer, String> origEncryptedPasswords = new HashMap<Integer, String>();
        DatabaseConnection connection = m_model.m_connection;
        Statement stmt = null;
        ResultSet result = null;
        m_model.getTableModel().reset();
        if (m_model.getTableModel().getRowCount() > 0) {
            this.selectRow(0);
        }
        try {
            stmt = connection.getConnection().createStatement();
            result = stmt.executeQuery(SQL_STMT_SELECT_FROM_PUBUSER);
            while (result.next()) {
                m_model.getTableModel().addRecord(result.getInt(FIELD_ID), result.getString(FIELD_NAME), result.getString(FIELD_PASS));
                origEncryptedPasswords.put(result.getInt(FIELD_ID), result.getString(FIELD_PASS));
            }
        }
        catch (Throwable e) {
            throw new UnableToPopulatePrivateLoginsTable(connection.getConnectionString(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (m_model.getTableModel().getRowCount() > 0) {
            this.selectRow(0);
        }
        this.reEncryptExistingPasswords(connection, origEncryptedPasswords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptExistingPasswords(DatabaseConnection connection, Map<Integer, String> origEncryptedPasswords) throws DBMTException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.getConnection().prepareStatement(UPDATE_REENCRYPTED_PASSWORD_SQL);
            for (Map.Entry<Integer, String> e : origEncryptedPasswords.entrySet()) {
                try {
                    String origEncryptedPassword = e.getValue();
                    String reEncryptedPassword = EntryPoint.f((String)origEncryptedPassword);
                    stmt.setString(1, reEncryptedPassword);
                    stmt.setInt(2, e.getKey());
                    stmt.execute();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    Connection conn = connection.getConnection();
                    if (conn.getAutoCommit()) continue;
                    conn.commit();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public boolean showButton(NavigationOperation op) {
        return op == NavigationOperation.PREV || op == NavigationOperation.CANCEL || op == NavigationOperation.SAVE || op == NavigationOperation.UNDO || op == NavigationOperation.OK;
    }

    private void selectRow(int row) {
        this.m_table.changeSelection(row, this.m_table.getSelectedColumn(), false, false);
    }

    private void finishEditingCell() {
        Component c = FocusManager.getCurrentManager().getFocusOwner();
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
    }

    private final class UsernameTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -4991804315383481096L;
        private final JTextField m_textField;
        private int currentRow;

        private UsernameTableCellEditor(JTextField textField) {
            super(textField);
            this.m_textField = textField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentRow = row;
            LoginTablePanel.this.selectRow(this.currentRow);
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.m_textField.selectAll();
            return c;
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = false;
            if (LoginTablePanel.this.model.getTableModel().isUniqueUsername(this.m_textField.getText())) {
                result = super.stopCellEditing();
            }
            LoginTablePanel.this.selectRow(this.currentRow);
            this.currentRow = -1;
            return result;
        }
    }

    private final class UserNameRenderer
    implements TableCellRenderer {
        private UserNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value.toString(), 2);
            LoginTablePanel.setCellFormatting(label, isSelected);
            return label;
        }
    }

    private final class TableHeaderRenderer
    implements TableCellRenderer {
        private TableHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value.toString(), 0);
            label.setOpaque(true);
            label.setBackground(UIManager.getColor("InternalFrame.activeTitleBackground"));
            label.setForeground(UIManager.getColor("InternalFrame.activeTitleForeground"));
            label.setFont(UIManager.getFont("Label.font").deriveFont(10.0f));
            return label;
        }
    }

    private final class SetPasswordButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = -905126449738815862L;

        public SetPasswordButtonAction() {
            super(StringLocalizer.get("dbmt.update.private.database.logins.button.setpasswd.label"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoginTablePanel.this.finishEditingCell();
            String password = new String(LoginTablePanel.this.m_pwdPassword.getPassword());
            String encryptedPassword = "";
            try {
                encryptedPassword = EntryPoint.b((String)password);
                LoginTablePanel.this.model.getTableModel().setNewPassword(LoginTablePanel.this.m_table.getSelectionModel().getLeadSelectionIndex(), encryptedPassword);
                LoginTablePanel.this.m_originalPassword = password;
                LoginTablePanel.this.m_passwordAltered = false;
                LoginTablePanel.this.m_btnSet.setEnabled(false);
                LoginTablePanel.this.ui.setSaveUndoButtonState();
            }
            catch (Exception err) {
                DBMTLogger.error(Channel.DEV, "Problem Encrypting Password", err);
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.update.private.database.error.encrypting.password"));
                encryptedPassword = "";
            }
        }
    }

    private final class PasswordFieldEnablerListner
    implements ListSelectionListener {
        private Integer lastSelected = null;

        private PasswordFieldEnablerListner() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int currentSelected = LoginTablePanel.this.m_table.getSelectedRow();
            LoginTablePanel.this.m_btnSet.setEnabled(currentSelected >= 0 && (this.lastSelected == null || this.lastSelected != currentSelected));
            this.lastSelected = currentSelected;
        }
    }

    private final class PasswordCaretListener
    extends MouseAdapter
    implements CaretListener,
    KeyListener {
        private PasswordCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.onUpdate();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.onUpdate();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.onUpdate();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.onUpdate();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.onUpdate();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.onUpdate();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.onUpdate();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.onUpdate();
        }

        private void onUpdate() {
            if (!LoginTablePanel.this.m_passwordAltered) {
                String newPasswordValue = new String(LoginTablePanel.this.m_pwdPassword.getPassword());
                LoginTablePanel.this.m_passwordAltered = !newPasswordValue.equals(LoginTablePanel.this.m_originalPassword);
            }
            LoginTablePanel.this.finishEditingCell();
            LoginTablePanel.this.m_btnSet.setEnabled(LoginTablePanel.this.m_passwordAltered);
        }
    }

    private final class LoginTableSelectionListener
    implements ListSelectionListener {
        private LoginTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = LoginTablePanel.this.m_table.getSelectedRow();
            if (selectedRow < 0 || selectedRow >= LoginTablePanel.this.m_table.getRowCount()) {
                LoginTablePanel.this.m_originalPassword = "";
                LoginTablePanel.this.m_pwdPassword.setText("");
                LoginTablePanel.this.m_passwordAltered = false;
                return;
            }
            String password = LoginTablePanel.this.model.getTableModel().getPassword(selectedRow);
            try {
                password = EntryPoint.d((String)password);
            }
            catch (PhoenixException e1) {
                password = "";
            }
            LoginTablePanel.this.m_originalPassword = password;
            LoginTablePanel.this.m_passwordAltered = false;
            LoginTablePanel.this.m_pwdPassword.setText(password);
        }
    }

    private final class GroupIdTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -2129359303306344135L;
        private final JTextField m_textField;

        private GroupIdTableCellEditor(JTextField textField) {
            super(textField);
            this.m_textField = textField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.m_textField.selectAll();
            return c;
        }

        @Override
        public boolean stopCellEditing() {
            int value = Integer.parseInt(this.m_textField.getText());
            if (LoginTablePanel.this.model.getTableModel().isUniqueGroupId(value)) {
                return super.stopCellEditing();
            }
            return false;
        }
    }

    private final class GroupIdRenderer
    implements TableCellRenderer {
        private GroupIdRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = new JLabel(value.toString(), 4);
            LoginTablePanel.setCellFormatting(label, isSelected);
            return label;
        }
    }

    private final class DeleteButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = -905126449738815862L;

        public DeleteButtonAction() {
            super(StringLocalizer.get("dbmt.update.private.database.logins.button.delete.label"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoginTablePanel.this.finishEditingCell();
            int selectedRow = LoginTablePanel.this.m_table.getSelectedRow();
            LoginTablePanel.this.model.getTableModel().deleteRecord(selectedRow);
            int newlySelectedRow = Math.min(selectedRow, LoginTablePanel.this.model.getTableModel().getRowCount() - 1);
            if (newlySelectedRow >= 0) {
                LoginTablePanel.this.selectRow(newlySelectedRow);
            }
            LoginTablePanel.this.ui.setSaveUndoButtonState();
        }
    }

    private final class AddButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 2046157270031923462L;

        private AddButtonAction() {
            super(StringLocalizer.get("dbmt.update.private.database.logins.button.add.label"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoginTablePanel.this.finishEditingCell();
            int groupId = LoginTablePanel.this.model.getTableModel().generateUniqueGroupId();
            int rowCount = LoginTablePanel.this.model.getTableModel().getRowCount();
            LoginTablePanel.this.model.getTableModel().addNewRecord(groupId, "", "");
            LoginTablePanel.this.selectRow(rowCount);
            LoginTablePanel.this.m_table.grabFocus();
            LoginTablePanel.this.m_table.editCellAt(rowCount, 1);
            LoginTablePanel.this.ui.setSaveUndoButtonState();
        }
    }
}

