/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginInfo;
import com.primavera.database.tools.dbmt.updatelogins.PrivateDatabaseLoginsTableModel;
import com.primavera.database.tools.dbmt.updatelogins.ui.ComponentPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.DatabaseConnectionPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdatePrivateDabaseLoginsModel {
    public static final String INITIAL_PAGE = ComponentPanel.getPanelId(DatabaseConnectionPanel.class);
    private PrivateDatabaseLoginsTableModel m_tableModel = new PrivateDatabaseLoginsTableModel();
    public final Set<PrivateDatabaseLoginInfo> m_alteredLogins = new HashSet<PrivateDatabaseLoginInfo>();
    public final Set<PrivateDatabaseLoginInfo> m_addedLogins = new HashSet<PrivateDatabaseLoginInfo>();
    public final List<String> m_transitionStack = new ArrayList<String>();
    public final Map<String, String> m_transitionMap = new HashMap<String, String>();
    public final Map<String, ComponentPanel> m_panelMap = new HashMap<String, ComponentPanel>();
    public ServerType dbType = ServerType.ORACLE;
    public DatabaseConnection m_connection = null;

    public PrivateDatabaseLoginsTableModel getTableModel() {
        return this.m_tableModel;
    }

    public synchronized String topPage() {
        if (this.m_transitionStack.isEmpty()) {
            return INITIAL_PAGE;
        }
        return this.m_transitionStack.get(this.m_transitionStack.size() - 1);
    }

    public void addPanel(ComponentPanel panel) {
        this.m_panelMap.put(panel.getPanelIdentifier(), panel);
    }

    public String nextPage(String fromPage) {
        return this.m_transitionMap.get(fromPage);
    }

    public synchronized void advance(String nextPage) {
        this.m_transitionStack.add(nextPage);
    }

    public synchronized void revert() {
        this.m_transitionStack.remove(this.m_transitionStack.size() - 1);
    }

    public void saveStateToDatabase() {
        if (this.m_connection == null) {
            DBMTLogger.warn(Channel.DEV, "Unable to save, connection does not exist");
            return;
        }
        this.getTableModel().writeEditsToDatabase(this.m_connection);
    }

    public void undoLastChange() {
        this.getTableModel().undoLastEdit();
    }

    public boolean areEditsPending() {
        return this.getTableModel().editCount() > 0;
    }
}

