/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.schemaval;

import com.primavera.common.StrUtil;
import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.schemaval.RunSchemaVal;

public class SchemaValidationTransformJob
extends AbstractJob {
    private final String m_connectString;
    private final String m_privilegedUser;
    private final String m_publicUser;
    private final String m_pxrptUser;
    private final ProductSuiteType m_productType;
    private String m_validationType = "";

    public SchemaValidationTransformJob(String connectstring, String privuser, String pubuser, String pxrptuser, ProductSuiteType productType) {
        this.m_connectString = connectstring;
        this.m_privilegedUser = privuser;
        this.m_publicUser = pubuser;
        this.m_pxrptUser = pxrptuser;
        this.m_productType = productType;
    }

    public SchemaValidationTransformJob(String connectstring, String privuser, String pubuser, String pxrptuser, ProductSuiteType productType, String validationType) {
        this.m_connectString = connectstring;
        this.m_privilegedUser = privuser;
        this.m_publicUser = pubuser;
        this.m_pxrptUser = pxrptuser;
        this.m_productType = productType;
        this.m_validationType = validationType;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return true;
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        DBMTLogger.info(Channel.USER, this.toString());
        DatabaseConnection connection = new DatabaseConnection(this.m_connectString);
        RunSchemaVal rsv = RunSchemaVal.getRunSchemaVal();
        rsv.setConnection(connection);
        rsv.setPrivilegedUser(this.m_privilegedUser);
        rsv.setPublicUser(this.m_publicUser);
        if (!StrUtil.isEmpty((String)this.m_pxrptUser)) {
            rsv.setPxrptUser(this.m_pxrptUser);
        }
        rsv.setSuite(this.m_productType);
        if (this.m_validationType.equals("migrate")) {
            rsv.runTransformForMigration();
        } else {
            rsv.runTransform();
        }
        return true;
    }

    public String toString() {
        return StringLocalizer.get("dbmt.schemavalidation.jobs.transform.name");
    }
}

