/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;

public class PercentComponentBinding
extends ComponentBinding {
    private final JProgressBar m_progressBar = new JProgressBar();

    public PercentComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        this.m_progressBar.setMaximum(100);
        this.m_progressBar.setMinimum(0);
        data.addDataChangedListener(new DataChangedListener(){

            @Override
            public void onDataChanged(InteractorData data, String field) {
                if (PercentComponentBinding.this.getFieldId().equals(field)) {
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(data.getValue(PercentComponentBinding.this.getFieldId()));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (Double.isNaN(value)) {
                        PercentComponentBinding.this.m_progressBar.setIndeterminate(true);
                    } else {
                        PercentComponentBinding.this.m_progressBar.setIndeterminate(false);
                        PercentComponentBinding.this.m_progressBar.setValue((int)(100.0 * value));
                    }
                }
            }
        });
    }

    @Override
    public void addChangeListener(ValueChangedListener listener) {
    }

    @Override
    public String getComponentData() {
        return Double.toString(this.m_progressBar.getPercentComplete());
    }

    @Override
    public JComponent[] getComponents() {
        return new JComponent[]{this.m_progressBar};
    }

    @Override
    public void setComponentData(String dataString) {
        double pct = Double.parseDouble(dataString);
        if (Double.isNaN(pct)) {
            this.m_progressBar.setIndeterminate(true);
        } else {
            this.m_progressBar.setIndeterminate(false);
            this.m_progressBar.setValue((int)(100.0 * pct));
        }
    }
}

