/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.EnumTypeDef;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.PasswordTypeDef;
import com.primavera.database.tools.dbmt.actions.ReadOnlyStringTypedef;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import com.primavera.database.tools.dbmt.gui.util.BooleanComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.EnumComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.FileComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.JobTreeComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.PasswordComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.PercentComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ReadOnlyStringComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.SelectComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.TextComponentBinding;
import java.io.File;
import java.util.Map;

public class ComponentUtil {
    private static final ComponentUtil s_instance = new ComponentUtil();

    public static ComponentBinding createComponent(InteractorData data, String fieldId, Map<String, ComponentBinding> bindings) {
        return s_instance.create(data, fieldId, bindings);
    }

    public ComponentBinding create(InteractorData data, String fieldId, Map<String, ComponentBinding> bindings) {
        try {
            ComponentBinding binding = this.createNewBinding(data, fieldId);
            String value = data.getString(fieldId);
            if (value != null) {
                binding.setComponentData(value);
            }
            binding.bindToField(bindings);
            return binding;
        }
        catch (InteractorDataError error) {
            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
            return null;
        }
    }

    private ComponentBinding createNewBinding(InteractorData data, String fieldId) {
        ValueDef valueDef = data.getDef().get(fieldId);
        Class<?> cls = valueDef.getTypeDef().getValueClass();
        if (cls == Boolean.class) {
            return new BooleanComponentBinding(data, fieldId);
        }
        if (cls == Double.class) {
            return new PercentComponentBinding(data, fieldId);
        }
        if (cls == File.class) {
            return new FileComponentBinding(data, fieldId);
        }
        if (cls == EnumTypeDef.getEnumClass()) {
            return new EnumComponentBinding(data, fieldId);
        }
        if (cls == SelectTypeDef.getSelectClass()) {
            return new SelectComponentBinding(data, fieldId);
        }
        if (cls == PasswordTypeDef.inst().getValueClass()) {
            return new PasswordComponentBinding(data, fieldId);
        }
        if (cls == JobTreeTypeDef.JobTreeTypeDefClass.class) {
            return new JobTreeComponentBinding(data, fieldId);
        }
        if (cls == ReadOnlyStringTypedef.inst().getValueClass()) {
            return new ReadOnlyStringComponentBinding(data, fieldId);
        }
        return new TextComponentBinding(data, fieldId);
    }
}

