/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.dialogs;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.gui.dialogs.DialogInteractor;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.JTextComponent;

public class IntegerRequiredValidator
implements DialogInteractor.Validator {
    Collection<JTextComponent> m_textComponents = new ArrayList<JTextComponent>();

    public IntegerRequiredValidator(JTextComponent[] textComponents) {
        for (JTextComponent text : textComponents) {
            this.m_textComponents.add(text);
        }
    }

    @Override
    public boolean isValid() {
        for (JTextComponent text : this.m_textComponents) {
            if (text == null || text.getText() == null || text.getText().trim().length() == 0) {
                return false;
            }
            try {
                Integer.parseInt(text.getText());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String reason() {
        return StringLocalizer.get("dbmt.interactor.addserver.portnum.intrequired");
    }
}

