/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.ApplicationProperties;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.util.ArrayList;

public class StringFormatUtil {
    private static int s_width = 0;
    static final String STRING_WIDTH_PROP_KEY = "dbmt.displaymessage.gui.width";
    public static final int DEFAULT_LINE_WIDTH = 120;

    public static String breakLines(String message) {
        int width = StringFormatUtil.getWidth();
        int latestBreak = 0;
        int latestSpace = 0;
        int currentLength = 0;
        ArrayList<Integer> lineStarts = new ArrayList<Integer>();
        lineStarts.add(0);
        for (int i = 0; i < message.length(); ++i) {
            char nextChar = message.charAt(i);
            boolean isBreak = StringFormatUtil.isBreakChar(nextChar);
            if (++currentLength > width) {
                if (latestSpace == (Integer)lineStarts.get(lineStarts.size() - 1)) {
                    lineStarts.add(i);
                    latestSpace = latestBreak = i;
                    currentLength = 0;
                    continue;
                }
                lineStarts.add(latestSpace);
                latestBreak = latestSpace;
                currentLength = i - latestBreak;
                continue;
            }
            if (!isBreak) continue;
            latestSpace = i;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < lineStarts.size() - 1; ++i) {
            sbuf.append(message.substring((Integer)lineStarts.get(i), (Integer)lineStarts.get(i + 1)).trim() + "\n");
        }
        sbuf.append(message.substring((Integer)lineStarts.get(lineStarts.size() - 1)).trim());
        return sbuf.toString();
    }

    public static synchronized int getWidth() {
        if (s_width == 0) {
            s_width = 120;
            String widthAsString = ApplicationProperties.getProps().getProperty(STRING_WIDTH_PROP_KEY);
            try {
                if (widthAsString != null) {
                    s_width = Integer.parseInt(widthAsString);
                }
            }
            catch (NumberFormatException e) {
                DBMTLogger.warn(Channel.USER, "Unable to parse message box length as int \"" + widthAsString + "\", using " + 120);
                s_width = 120;
            }
        }
        return s_width;
    }

    static boolean isBreakChar(char ch) {
        return Character.isWhitespace(ch);
    }
}

