/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.SetActionTypeTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.gui.ApplicationUI;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunner;
import com.primavera.database.tools.dbmt.gui.GuiWizardRunnerPage;
import com.primavera.database.tools.dbmt.gui.InteractorPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.text.JTextComponent;

public abstract class DefaultGuiWizardRunner
extends GuiWizardRunner {
    private static final String DISMISS_DIALOG_ACTION = "DismissDialog";
    private static final String DK_SHADOW_COLOR_NAME = "controlDkShadow";
    private static final String LT_HILITE_COLOR_NAME = "controlLtHighlight";
    private Action m_nextAction = new ProceedAction(WizardNavigationAction.NEXT);
    private Action m_installAction = new ProceedAction(WizardNavigationAction.INSTALL);
    private Action m_upgradeAction = new ProceedAction(WizardNavigationAction.UPGRADE);
    private Action m_createAction = new ProceedAction(WizardNavigationAction.CREATE);
    private Action m_prevAction = new PrevAction(WizardNavigationAction.PREV);
    private Action m_cancelAction = this.createCancleAction();
    private Action m_finishAction = this.createFinishAction();
    private final JButton[] m_buttons = new JButton[WizardNavigationAction.values().length];
    private final JLabel m_pageTitleLabel = new JLabel();
    private final Icon m_pageIcon = DefaultGuiWizardRunner.getPageIcon();
    private final JTextArea m_pageDescriptionText = new JTextArea();
    private boolean m_accept = false;

    public DefaultGuiWizardRunner(WizardInteractorData data, String actionPath) {
        super(data, actionPath);
    }

    protected Action getCancelAction() {
        return this.m_cancelAction;
    }

    protected abstract Action createCancleAction();

    protected abstract Action createFinishAction();

    private static Icon getPageIcon() {
        try {
            BufferedImage appIcon = ImageIO.read(ClassLoader.getSystemResource("com/primavera/database/tools/dbmt/gui/DBMTApplicationIconShadow.png"));
            if (appIcon != null) {
                return new ImageIcon(appIcon);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void layoutDialog(WizardInteractorData data, String actionPath) {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), DISMISS_DIALOG_ACTION);
        this.getRootPane().getActionMap().put(DISMISS_DIALOG_ACTION, this.m_cancelAction);
        this.m_pageTitleLabel.setFont(this.m_pageTitleLabel.getFont().deriveFont(1, 18.0f));
        Action[] buttonActions = new Action[]{this.m_prevAction, this.m_cancelAction, this.m_finishAction, this.m_installAction, this.m_upgradeAction, this.m_createAction, this.m_nextAction};
        for (int i = 0; i < this.m_buttons.length; ++i) {
            this.m_buttons[i] = new JButton(buttonActions[i]);
            this.m_buttons[i].setText(WizardNavigationAction.values()[i].getName());
            this.m_buttons[i].setToolTipText(WizardNavigationAction.values()[i].getDesc());
            this.m_buttons[i].setBorder((Border)UIManager.getDefaults().get("WizardButton.border"));
            this.m_buttons[i].setBackground((Color)UIManager.getDefaults().get("WizardButton.background"));
            char mnemonic = WizardNavigationAction.values()[i].getMnemonic();
            if (mnemonic == '\u0000') continue;
            this.m_buttons[i].setMnemonic(mnemonic);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new FlowLayout(4));
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new FlowLayout(2));
        JPanel superButtonPanel = new JPanel();
        superButtonPanel.setLayout(new FlowLayout(4));
        Border hrBorder = this.createButtonAreaBorder();
        superButtonPanel.setBorder(hrBorder);
        this.addWizardButtonsToPanel(leftButtonPanel, rightButtonPanel);
        superButtonPanel.add(rightButtonPanel);
        superButtonPanel.add(leftButtonPanel);
        JPanel pageTitlePanel = new JPanel();
        pageTitlePanel.setLayout(new BorderLayout());
        Color headerBg = this.getHeaderBackground();
        pageTitlePanel.setBackground(headerBg);
        this.m_pageTitleLabel.setBackground(headerBg);
        this.m_pageDescriptionText.setBackground(headerBg);
        this.m_pageDescriptionText.setFont(UIManager.getFont("JPanel.font"));
        this.m_pageDescriptionText.setBorder(this.getPageDescriptionBorder());
        this.m_pageDescriptionText.setWrapStyleWord(true);
        this.m_pageDescriptionText.setLineWrap(true);
        this.m_pageDescriptionText.setEditable(false);
        this.m_pageDescriptionText.setFocusable(false);
        Color headerFg = this.getHeaderForeground();
        pageTitlePanel.setForeground(headerFg);
        this.m_pageTitleLabel.setForeground(headerFg);
        this.m_pageDescriptionText.setForeground(UIManager.getColor("JPanel.foreground"));
        JPanel headerPanel = new JPanel();
        headerPanel.setBackground(headerBg);
        headerPanel.setBorder(this.createHeaderBorder());
        headerPanel.setLayout(new BorderLayout());
        JPanel headerAndDescriptionPanel = new JPanel();
        headerAndDescriptionPanel.setLayout(new BorderLayout());
        headerAndDescriptionPanel.add((Component)headerPanel, "North");
        JLabel imageLabel = new JLabel(this.m_pageIcon);
        imageLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 20));
        headerPanel.add((Component)pageTitlePanel, "Center");
        pageTitlePanel.add((Component)this.m_pageTitleLabel, "Center");
        pageTitlePanel.add((Component)this.m_pageDescriptionText, "South");
        this.getContentPane().add((Component)headerAndDescriptionPanel, "North");
        this.getContentPane().add((Component)superButtonPanel, "South");
        this.getWindow().setLocationByPlatform(true);
        ApplicationUI.setIcon(this.getIconTarget());
    }

    private Color getHeaderForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    private Color getHeaderBackground() {
        return UIManager.getColor("TextArea.background");
    }

    private Border getPageDescriptionBorder() {
        return BorderFactory.createEmptyBorder(10, 0, 0, 0);
    }

    private void addWizardButtonsToPanel(JPanel leftButtonPanel, JPanel rightButtonPanel) {
        for (int i = 0; i < this.m_buttons.length; ++i) {
            if (i == WizardNavigationAction.CANCEL.ordinal() || i == WizardNavigationAction.FINISH.ordinal()) {
                leftButtonPanel.add(this.m_buttons[i]);
                continue;
            }
            rightButtonPanel.add(this.m_buttons[i]);
        }
    }

    private Border createButtonAreaBorder() {
        Color shadowColor = UIManager.getColor(DK_SHADOW_COLOR_NAME);
        Color hightlightColor = UIManager.getColor(LT_HILITE_COLOR_NAME);
        MatteBorder outerBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, shadowColor);
        MatteBorder innerBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, hightlightColor);
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    private Border createHeaderBorder() {
        Color shadowColor = UIManager.getColor(DK_SHADOW_COLOR_NAME);
        Color hightlightColor = UIManager.getColor(LT_HILITE_COLOR_NAME);
        MatteBorder innerBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, shadowColor);
        MatteBorder outerBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, hightlightColor);
        Border spacingBorder = BorderFactory.createEmptyBorder(10, 20, 6, 0);
        return BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder), spacingBorder);
    }

    protected WizardRunner getRunner() {
        return this;
    }

    @Override
    protected InteractorPage createNewPage() {
        return new GuiWizardRunnerPage(this);
    }

    @Override
    public final boolean isAccept() {
        return this.m_accept;
    }

    public final void accept() {
        this.m_accept = true;
    }

    @Override
    public JButton getButton(WizardNavigationAction stock) {
        return this.m_buttons[stock.ordinal()];
    }

    @Override
    public JLabel getTitleLabel() {
        return this.m_pageTitleLabel;
    }

    @Override
    public JTextComponent getDescriptionLabel() {
        return this.m_pageDescriptionText;
    }

    @Override
    protected JButton getDefaultButton() {
        if (this.getButton(WizardNavigationAction.NEXT).isVisible()) {
            return this.getButton(WizardNavigationAction.NEXT);
        }
        if (this.getButton(WizardNavigationAction.FINISH).isVisible()) {
            return this.getButton(WizardNavigationAction.FINISH);
        }
        if (this.getButton(WizardNavigationAction.INSTALL).isVisible()) {
            return this.getButton(WizardNavigationAction.INSTALL);
        }
        if (this.getButton(WizardNavigationAction.UPGRADE).isVisible()) {
            return this.getButton(WizardNavigationAction.UPGRADE);
        }
        if (this.getButton(WizardNavigationAction.CREATE).isVisible()) {
            return this.getButton(WizardNavigationAction.CREATE);
        }
        return null;
    }

    private class ProceedAction
    extends AbstractAction {
        private static final long serialVersionUID = -1222541338641523595L;

        public ProceedAction(WizardNavigationAction action) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String procErrorMessage = DefaultGuiWizardRunner.this.getAction().postProcess(DefaultGuiWizardRunner.this.getRunner(), DefaultGuiWizardRunner.this.getData(), DefaultGuiWizardRunner.this.m_jobProps, DefaultGuiWizardRunner.this.topPage());
            if (procErrorMessage != null) {
                DefaultGuiWizardRunner.this.displayMessage(procErrorMessage);
                return;
            }
            String nextPage = DefaultGuiWizardRunner.this.getData().getNextPage(DefaultGuiWizardRunner.this.topPage());
            if (nextPage == null) {
                return;
            }
            DefaultGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(3));
            try {
                String errorMessage = DefaultGuiWizardRunner.this.getAction().tryToLeavePage(DefaultGuiWizardRunner.this.getRunner(), DefaultGuiWizardRunner.this.getData(), DefaultGuiWizardRunner.this.m_jobProps, DefaultGuiWizardRunner.this.topPage(), nextPage);
                if (nextPage.equals("upgrade_status") && DefaultGuiWizardRunner.this.m_jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.UPGRADE && DefaultGuiWizardRunner.this.m_rollbackFilePrefix == null) {
                    DefaultGuiWizardRunner.this.m_rollbackFilePrefix = DefaultGuiWizardRunner.this.m_jobProps.getJobProperty("version").toString();
                }
                if (errorMessage == null) {
                    DefaultGuiWizardRunner.this.pushPage(nextPage);
                    DefaultGuiWizardRunner.this.getAction().preparePage(DefaultGuiWizardRunner.this.getRunner(), DefaultGuiWizardRunner.this.getData(), DefaultGuiWizardRunner.this.m_jobProps, DefaultGuiWizardRunner.this.topPage());
                    DefaultGuiWizardRunner.this.setPage(nextPage);
                } else {
                    DefaultGuiWizardRunner.this.displayMessage(errorMessage);
                }
            }
            catch (Exception error) {
                error.printStackTrace();
                DefaultGuiWizardRunner.this.displayMessage(error.getClass().getSimpleName() + ": " + error.getMessage() + " (" + error.getLocalizedMessage() + ")");
            }
            finally {
                DefaultGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class PrevAction
    extends AbstractAction {
        private static final long serialVersionUID = -8774227031343342468L;

        public PrevAction(WizardNavigationAction action) {
            super(action.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultGuiWizardRunner.this.firstPage()) {
                return;
            }
            try {
                DefaultGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    String topPage = DefaultGuiWizardRunner.this.topPage();
                    DefaultGuiWizardRunner.this.popPage();
                    DefaultGuiWizardRunner.this.getAction().undoPage(DefaultGuiWizardRunner.this.getRunner(), DefaultGuiWizardRunner.this.getData(), DefaultGuiWizardRunner.this.m_jobProps, DefaultGuiWizardRunner.this.topPage(), topPage);
                    DefaultGuiWizardRunner.this.setPage(DefaultGuiWizardRunner.this.topPage());
                }
                finally {
                    DefaultGuiWizardRunner.this.getWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (InteractorDataError error) {
                DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
            }
        }
    }
}

