/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionContext;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.ContextChangedListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ActionLogicAction
extends AbstractAction
implements ContextChangedListener {
    private static final long serialVersionUID = 3967852281940368834L;
    private final ActionOperation m_logic;

    public ActionLogicAction(ActionOperation logic) {
        super(StringLocalizer.get(logic.getNameKey()));
        this.putValue("ShortDescription", StringLocalizer.get(logic.getDescKey()));
        this.m_logic = logic;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_logic.perform();
        }
        catch (ActionFailed ex) {
            DBMTLogger.error(Channel.USER, "The action failed: " + ex.getMessage());
        }
    }

    @Override
    public void onContextChanged(ActionContext context) {
        this.setEnabled(this.m_logic.contextLogic().resetFromContext(context));
    }
}

