/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.util.HashSet;

public class TemporaryTablespaceName
implements FieldProcessor {
    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        HashSet<String> tempTablespaces = new HashSet<String>();
        tempTablespaces.addAll(OracleLogic.getTemporaryTablespaces(new DatabaseConnection(props.getConnection(ConnectionClass.SYSADMIN))));
        if (tempTablespaces.isEmpty()) {
            throw new Exception(StringLocalizer.get("dbmt.error.no.temp.tablespaces"));
        }
        if (tempTablespaces.contains(fieldValue)) {
            return fieldValue;
        }
        String someRandomeTempTablespace = (String)tempTablespaces.iterator().next();
        DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.error.using.temp.tablespaces", new String[]{someRandomeTempTablespace}));
        return someRandomeTempTablespace;
    }

    @Override
    public boolean validateValue(String fieldValue) {
        return true;
    }
}

