/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;

public abstract class SqlServerDatabaseFileForSchema
implements FieldProcessor {
    private final String m_subExtention;
    private final String m_extention;

    public SqlServerDatabaseFileForSchema(String subExtention, String extention) {
        this.m_subExtention = subExtention;
        this.m_extention = extention;
    }

    @Override
    public boolean validateValue(String fieldValue) {
        return true;
    }

    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        String connectionString = props.getConnection(ConnectionClass.SYSADMIN);
        String sqlServerDatafilePath = this.getDatabaseFileDirectory(connectionString) + "\\";
        String databaseName = this.getDatabaseName(data, fieldValue, props);
        return sqlServerDatafilePath + this.getFileName(databaseName);
    }

    private String getFileName(String databaseName) {
        return databaseName + "_" + this.m_subExtention + "." + this.m_extention;
    }

    protected abstract String getDatabaseName(WizardInteractorData var1, String var2, JobProperties var3) throws InteractorDataError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseFileDirectory(String connectionString) throws Exception {
        try (DatabaseConnection connection = null;){
            connection = new DatabaseConnection(connectionString);
            String string = SqlServerLogic.getMasterFileDirectory(connection);
            return string;
        }
    }
}

