/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.CommandLineActionObject;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgument;
import com.primavera.database.tools.dbmt.cmd.InvalidCommandLineArgumentValue;
import com.primavera.schema.pmdbs.command._1.TField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldParameterProcessor
extends CommandLineActionObject.ParameterProcessor {
    public static final FieldProcessor NOOP_FIELD_PROCESSOR = new FieldProcessor(){

        @Override
        public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties jobProps) {
            return fieldValue;
        }

        @Override
        public boolean validateValue(String fieldValue) {
            return true;
        }
    };
    private final List<TField> m_fields = new ArrayList<TField>();
    private final CommandLineActionObject m_cmdLineObject;

    public FieldParameterProcessor(CommandLineActionObject cmdLineObject, String id, List<TField> fields) {
        super(id);
        this.m_fields.addAll(fields);
        this.m_cmdLineObject = cmdLineObject;
    }

    @Override
    public void prepareArgumentValue(Map<String, String> paramMap, Map<String, Map<String, Set<CommandLineActionObject.ValueAndProcessor>>> valueMap) throws InvalidCommandLineArgument, InvalidCommandLineArgumentValue {
        for (TField field : this.m_fields) {
            Set<CommandLineActionObject.ValueAndProcessor> valueSet;
            FieldProcessor processor = CommandLineActionObject.getFieldProcessor(field.getProcessor());
            String value = paramMap.get(this.getId());
            if (!paramMap.keySet().contains(this.getId())) continue;
            if (value == null) {
                value = "";
            }
            if (!processor.validateValue(value)) {
                DBMTLogger.info(Channel.DEV, "Processor " + processor.getClass().getSimpleName() + " failed");
                throw new InvalidCommandLineArgumentValue(this.getCommandLineObject(), this.m_id, value);
            }
            Map<String, Set<CommandLineActionObject.ValueAndProcessor>> pageMap = valueMap.get(field.getPage());
            if (pageMap == null) {
                pageMap = new HashMap<String, Set<CommandLineActionObject.ValueAndProcessor>>();
                valueMap.put(field.getPage(), pageMap);
            }
            if ((valueSet = pageMap.get(field.getField())) == null) {
                valueSet = new HashSet<CommandLineActionObject.ValueAndProcessor>();
                pageMap.put(field.getField(), valueSet);
            }
            int seq = field.getSeq() == null ? 1 : field.getSeq().intValue();
            valueSet.add(new CommandLineActionObject.ValueAndProcessor(value, processor, seq));
        }
    }

    private CommandLineActionObject getCommandLineObject() {
        return this.m_cmdLineObject;
    }
}

