/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.SchemaType;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;

public abstract class BaseTablespaceNameForSchema
implements FieldProcessor {
    private static final SchemaType DEFAULT_SCHEMA = SchemaType.EXP;

    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        SchemaType suiteType = this.getProductSuiteTypeFromSchemaFlag(fieldValue);
        return this.getBaseTablename(suiteType);
    }

    private SchemaType getProductSuiteTypeFromSchemaFlag(String fieldValue) {
        if (fieldValue == null) {
            return DEFAULT_SCHEMA;
        }
        if ("".equals(fieldValue)) {
            return DEFAULT_SCHEMA;
        }
        if (fieldValue.toUpperCase().equals("PM")) {
            return SchemaType.PM;
        }
        if (fieldValue.toUpperCase().equals("PPM")) {
            return SchemaType.PPM;
        }
        if (fieldValue.toUpperCase().equals("MM")) {
            return SchemaType.MM;
        }
        if (fieldValue.toUpperCase().equals("GROUP")) {
            return SchemaType.EXP;
        }
        if (fieldValue.toUpperCase().equals("ADMIN")) {
            return SchemaType.EXPADM;
        }
        return DEFAULT_SCHEMA;
    }

    protected abstract String getBaseTablename(SchemaType var1);

    @Override
    public boolean validateValue(String fieldValue) {
        String uppercaseValue = fieldValue.toUpperCase();
        if (uppercaseValue.isEmpty()) {
            return true;
        }
        if ("MM".equals(uppercaseValue)) {
            return true;
        }
        if ("PM".equals(uppercaseValue)) {
            return true;
        }
        if ("GROUP".equals(uppercaseValue)) {
            return true;
        }
        return "ADMIN".equals(uppercaseValue);
    }
}

