/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.locale.StringLocalizer;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public enum WizardNavigationAction {
    PREV("prev", "com/primavera/database/tools/dbmt/gui/WizardButtons_Backwards.png"),
    CANCEL("cancel", "com/primavera/database/tools/dbmt/gui/WizardButtons_Cancel.png"),
    FINISH("finish", "com/primavera/database/tools/dbmt/gui/WizardButtons_Finish.png"),
    INSTALL("install", "com/primavera/database/tools/dbmt/gui/WizardButtons_Forward.png"),
    UPGRADE("upgrade", "com/primavera/database/tools/dbmt/gui/WizardButtons_Forward.png"),
    CREATE("create", "com/primavera/database/tools/dbmt/gui/WizardButtons_Forward.png"),
    NEXT("next", "com/primavera/database/tools/dbmt/gui/WizardButtons_Forward.png");

    private final String m_nameText;
    private final String m_descText;
    private final char m_mnemonic;
    private final ImageIcon m_icon;

    private WizardNavigationAction(String buttonId, String iconPath) {
        this.m_nameText = StringLocalizer.get("dbmt.standard.buttons." + buttonId + ".name");
        this.m_descText = StringLocalizer.get("dbmt.standard.buttons." + buttonId + ".desc");
        char mnemonic = '\u0000';
        String mnemonicString = StringLocalizer.get("dbmt.standard.buttons." + buttonId + ".mnemonic");
        if (Character.isLetter(mnemonicString.charAt(0))) {
            mnemonic = Character.toUpperCase(mnemonicString.charAt(0));
        }
        this.m_mnemonic = mnemonic;
        this.m_icon = this.getIcon(iconPath);
    }

    private ImageIcon getIcon(String iconPath) {
        URL iconUrl = ClassLoader.getSystemResource(iconPath);
        if (iconUrl == null) {
            return null;
        }
        return new ImageIcon(iconUrl);
    }

    public String getName() {
        return this.m_nameText;
    }

    public String getDesc() {
        return this.m_descText;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public final char getMnemonic() {
        return this.m_mnemonic;
    }
}

