/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class VerifyUserDoesNotExist
implements TransitionMap.TransitionValidator {
    private static final String FIELD_ID_USERNAME = "username";
    private static final ConnectionClass CONNECTION_CLASS = ConnectionClass.SYSADMIN;

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) {
        try {
            String connectionString = jobProps.getConnection(CONNECTION_CLASS);
            HashSet<String> existingOracleUsers = new HashSet<String>();
            existingOracleUsers.addAll(VerifyUserDoesNotExist.getExistingUsers(connectionString));
            String providedUserName = data.getValue(page, FIELD_ID_USERNAME);
            if (existingOracleUsers.contains(providedUserName)) {
                ConnectStringParse parsedConnectString = new ConnectStringParse(jobProps.getConnection(CONNECTION_CLASS));
                return StringLocalizer.get("dbmt.error.install.oracle.usersexist", new String[]{parsedConnectString.getDatabase(), providedUserName});
            }
            return null;
        }
        catch (InteractorDataError e) {
            return e.getLocalizedMessage();
        }
        catch (ConnectionNotFoundException e) {
            return e.getLocalizedMessage();
        }
        catch (Throwable th) {
            return th.getClass().getSimpleName() + " " + th.getLocalizedMessage() + " (" + th.getMessage() + ")";
        }
    }

    public static Set<String> getExistingUsers(String connectionString) {
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
            Set<String> set = OracleLogic.getExistingUsers(conn);
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

