/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetUseUnicodeParameter
implements TransitionMap.TransitionOperation {
    private final String m_useUnicodeFieldName;

    public SetUseUnicodeParameter() {
        this("unicode");
    }

    public SetUseUnicodeParameter(String fieldName) {
        this.m_useUnicodeFieldName = fieldName;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        jobProps.setJobProperty("unicode", this.getUseUnicodeDataSuffix(page, data));
        return null;
    }

    private Object getUseUnicodeDataSuffix(String page, WizardInteractorData data) throws InteractorDataError {
        if (data.getValue(page, this.m_useUnicodeFieldName).toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
            return "_nvarchar";
        }
        return "";
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty("unicode");
    }
}

