/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.InvalidVersionStringException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetUpgradeNeedsWebUserOptionsPageOR
implements TransitionMap.TransitionOperation {
    private static final String FIRST_SCHEMA_VERSION_WITH_WEB_USER = "0700.0001.0001.0002";
    private static final String FIRST_SCHEMA_VERSION_WITH_BGJOB_USER = "0710.0001.0001.0015";
    private static final String NEEDS_WEBUSER_OPTIONS_FIELD_NAME = "webuseroptions";
    private static final String BGJOBUSER_EXISTS = "bgjobuser_exists";

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        boolean value = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM;
        boolean versionAlreadyHasWebUser = SetUpgradeNeedsWebUserOptionsPageOR.versionGreaterThanOrEqualTo(jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY).toString(), FIRST_SCHEMA_VERSION_WITH_WEB_USER);
        String webuseroptionsValue = Boolean.toString(value && !versionAlreadyHasWebUser);
        data.getPageData(page).setValue(NEEDS_WEBUSER_OPTIONS_FIELD_NAME, webuseroptionsValue);
        boolean installedBGjobUser = SetUpgradeNeedsWebUserOptionsPageOR.versionGreaterThanOrEqualTo(jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY).toString(), FIRST_SCHEMA_VERSION_WITH_BGJOB_USER);
        data.getPageData(page).setValue(BGJOBUSER_EXISTS, Boolean.toString(installedBGjobUser));
        return null;
    }

    private static boolean versionGreaterThanOrEqualTo(String installedVersion, String firstVersionWithWebUsers) throws InvalidVersionStringException {
        String[] splitInstalledVersion = installedVersion.split("\\.");
        String[] splitThreasholdVersion = firstVersionWithWebUsers.split("\\.");
        for (int i = 0; i < Math.max(splitInstalledVersion.length, splitThreasholdVersion.length); ++i) {
            if (i < splitInstalledVersion.length && i < splitThreasholdVersion.length) {
                int comparsionResult = splitInstalledVersion[i].compareTo(splitThreasholdVersion[i]);
                if (comparsionResult > 0) {
                    return true;
                }
                if (comparsionResult >= 0) continue;
                return false;
            }
            throw new InvalidVersionStringException(installedVersion);
        }
        return true;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

