/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SchemaValidationOptionKeys;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetServerTypeTransOp
implements TransitionMap.TransitionOperation {
    private final ServerType m_type;

    public SetServerTypeTransOp(ServerType type) {
        this.m_type = type;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        jobProps.setJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY, (Object)this.m_type);
        jobProps.setJobProperty(SchemaValidationOptionKeys.PRIVILEGED_USER_NAME_KEY, "PRIVUSER");
        jobProps.setJobProperty(SchemaValidationOptionKeys.PUBLIC_USER_NAME_KEY, "PUBUSER");
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY);
    }
}

