/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.HashMap;
import java.util.Map;

public class SetServerTypeFromPageTransOp
implements TransitionMap.TransitionOperation {
    private static final Map<String, ServerType> DEFAULT_MAP = new HashMap<String, ServerType>();
    private final String m_pageId;
    private final String m_fieldId;
    private final Map<String, ServerType> m_valueMap = new HashMap<String, ServerType>();

    public SetServerTypeFromPageTransOp(String pageId, String fieldId) {
        this(pageId, fieldId, DEFAULT_MAP);
    }

    public SetServerTypeFromPageTransOp(String pageId, String fieldId, Map<String, ServerType> valueMap) {
        DEFAULT_MAP.put("OR", ServerType.ORACLE);
        DEFAULT_MAP.put("SS", ServerType.SQLSERVER);
        DEFAULT_MAP.put("OR_ATP", ServerType.ORACLEATP);
        this.m_pageId = pageId;
        this.m_fieldId = fieldId;
        this.m_valueMap.putAll(DEFAULT_MAP);
        this.m_valueMap.putAll(valueMap);
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        String value = data.getValue(this.m_pageId, this.m_fieldId);
        jobProps.setJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY, (Object)this.m_valueMap.get(value));
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY);
    }
}

