/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InstallSuitePropertyAction;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SetSSUpgradeExpUseUnicode
implements TransitionMap.TransitionOperation {
    private final ApplicationContextLogic m_context;

    public SetSSUpgradeExpUseUnicode(ApplicationContextLogic context) {
        this.m_context = context;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        if (jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY) != ProductSuiteType.EXP) {
            return null;
        }
        SchemaType schemaType = (SchemaType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_UPGRADE_KEY));
        List<SchemaInfo> schemas = InstallSuitePropertyAction.getSchemaInfo(this.m_context, schemaType, (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY)));
        SchemaInfo productSchema = InstallSuitePropertyAction.getProductSchema(schemas, schemaType);
        String versionQuery = productSchema.getVersionQuery(ServerType.SQLSERVER);
        boolean useUnicode = this.isVersionFieldUnicode(jobProps.getConnection(ConnectionClass.ADMINISTRATIVE), versionQuery);
        jobProps.setJobProperty("unicode", this.getUseUnicodeDataSuffix(useUnicode));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVersionFieldUnicode(String connectString, String versionQuery) {
        DatabaseConnection connection = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = new DatabaseConnection(connectString);
            stmt = connection.getConnection().prepareStatement(versionQuery);
            stmt.execute();
            resultSet = stmt.getResultSet();
            String columnType = resultSet.getMetaData().getColumnTypeName(1);
            DBMTLogger.info(Channel.DEV, "The VERSION column has type " + columnType);
            boolean bl = "nvarchar".equalsIgnoreCase(columnType);
            this.closeDBResources(connection, stmt, resultSet);
            return bl;
        }
        catch (Exception e) {
            try {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.error.schematypecannotbedetermined", new String[]{connection.getDatabase()}), e);
                e.printStackTrace();
                boolean bl = false;
                this.closeDBResources(connection, stmt, resultSet);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeDBResources(connection, stmt, resultSet);
                throw throwable;
            }
        }
    }

    private void closeDBResources(DatabaseConnection connection, PreparedStatement stmt, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String getUseUnicodeDataSuffix(boolean useUnicode) {
        if (useUnicode) {
            return "_nvarchar";
        }
        return "";
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty("unicode");
    }
}

