/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.HashMap;
import java.util.Map;

public class SetSSCreateParamsTransOp
implements TransitionMap.TransitionOperation {
    private static final String PM_PARAM_DATABASE_NAME = "pm.ss.database_name";
    private static final String PM_PARAM_DATAFILE = "pm.ss.data_path";
    private static final String PM_PARAM_LOGFILE = "pm.ss.log_path";
    private static final String PM_PARAM_CODEPAGE = "pm.ss.codepage";
    private static final String MM_PARAM_DATABASE_NAME = "mm.ss.database_name";
    private static final String MM_PARAM_DATAFILE = "mm.ss.data_path";
    private static final String MM_PARAM_LOGFILE = "mm.ss.log_path";
    private static final String MM_PARAM_CODEPAGE = "mm.ss.codepage";
    private static final String EXP_PARAM_DATABASE_NAME = "exp.ss.database_name";
    private static final String EXP_PARAM_DATAFILE = "exp.ss.data_path";
    private static final String EXP_PARAM_LOGFILE = "exp.ss.log_path";
    private static final String EXP_PARAM_CODEPAGE = "exp.ss.codepage";
    private static final String EXPADMIN_PARAM_DATABASE_NAME = "expadm.ss.database_name";
    private static final String EXPADMIN_PARAM_DATAFILE = "expadm.ss.data_path";
    private static final String EXPADMIN_PARAM_LOGFILE = "expadm.ss.log_path";
    private static final String EXPADMIN_PARAM_CODEPAGE = "expadm.ss.codepage";
    private static final Map<String, String> EMPTY_FIELD_MAP = new HashMap<String, String>();
    private static final String DBNAME_FIELD = "dbname";
    private static final String DATAFILE_FIELD = "datafile";
    private static final String LOGFILE_FIELD = "logfile";
    private static final String CODEPAGE_FIELD = "dbcodepage";
    private final String m_pageId;
    private final Map<String, String> m_fieldMap = new HashMap<String, String>();

    public SetSSCreateParamsTransOp(String pageId, Map<String, String> fieldMap) {
        this.m_pageId = pageId;
        this.m_fieldMap.putAll(fieldMap);
    }

    public SetSSCreateParamsTransOp(String pageId) {
        this(pageId, EMPTY_FIELD_MAP);
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        Object productSuite = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY);
        if (productSuite == ProductSuiteType.PM || productSuite == ProductSuiteType.PPM) {
            Object pmProduct = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY);
            if (pmProduct == null) {
                return StringLocalizer.get("dmbt.job.uset.schema.pm");
            }
            if (pmProduct == SchemaType.PM || pmProduct == SchemaType.PPM) {
                jobProps.getScriptProperties().put(PM_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.gatMappedFieldId(DBNAME_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_DATAFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(DATAFILE_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_LOGFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(LOGFILE_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_CODEPAGE, this.getDatabaseCodepage(data));
                return null;
            }
            if (pmProduct == SchemaType.MM) {
                jobProps.getScriptProperties().put(MM_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.gatMappedFieldId(DBNAME_FIELD)));
                jobProps.getScriptProperties().put(MM_PARAM_DATAFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(DATAFILE_FIELD)));
                jobProps.getScriptProperties().put(MM_PARAM_LOGFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(LOGFILE_FIELD)));
                jobProps.getScriptProperties().put(MM_PARAM_CODEPAGE, this.getDatabaseCodepage(data));
                return null;
            }
            return StringLocalizer.get("dmbt.job.unknown.schema.pm", new String[]{productSuite.getClass().getSimpleName(), productSuite.toString()});
        }
        if (productSuite == ProductSuiteType.EXP) {
            Object expProduct = jobProps.getJobProperty(InstallSuiteOptionKeys.EXPEDITION_SCHEMA_KEY);
            if (expProduct == null) {
                return StringLocalizer.get("dmbt.job.uset.schema.exp");
            }
            if (expProduct == SchemaType.EXP) {
                jobProps.getScriptProperties().put(EXP_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.gatMappedFieldId(DBNAME_FIELD)));
                jobProps.getScriptProperties().put(EXP_PARAM_DATAFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(DATAFILE_FIELD)));
                jobProps.getScriptProperties().put(EXP_PARAM_LOGFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(LOGFILE_FIELD)));
                jobProps.getScriptProperties().put(EXP_PARAM_CODEPAGE, this.getDatabaseCodepage(data));
                return null;
            }
            if (expProduct == SchemaType.EXPADM) {
                jobProps.getScriptProperties().put(PM_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.gatMappedFieldId(DBNAME_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_DATAFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(DATAFILE_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_LOGFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(LOGFILE_FIELD)));
                jobProps.getScriptProperties().put(PM_PARAM_CODEPAGE, this.getDatabaseCodepage(data));
                jobProps.getScriptProperties().put(EXPADMIN_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.gatMappedFieldId(DBNAME_FIELD)));
                jobProps.getScriptProperties().put(EXPADMIN_PARAM_DATAFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(DATAFILE_FIELD)));
                jobProps.getScriptProperties().put(EXPADMIN_PARAM_LOGFILE, data.getValue(this.m_pageId, this.gatMappedFieldId(LOGFILE_FIELD)));
                jobProps.getScriptProperties().put(EXPADMIN_PARAM_CODEPAGE, this.getDatabaseCodepage(data));
                return null;
            }
            return StringLocalizer.get("dmbt.job.unknown.schema.exp", new String[]{expProduct.toString()});
        }
        return StringLocalizer.get("dmbt.job.unknown.product.type", new String[]{productSuite.getClass().getSimpleName(), productSuite.toString()});
    }

    private String getDatabaseCodepage(WizardInteractorData data) throws InteractorDataError {
        String databaseCodepage = data.getValue(this.m_pageId, this.gatMappedFieldId(CODEPAGE_FIELD));
        if (databaseCodepage == null || "DATABASE_DEFAULT".equalsIgnoreCase(databaseCodepage)) {
            return "";
        }
        return databaseCodepage;
    }

    private String gatMappedFieldId(String field) {
        String mappedField = this.m_fieldMap.get(field);
        if (mappedField == null) {
            return field;
        }
        return mappedField;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.getScriptProperties().remove(PM_PARAM_DATABASE_NAME);
        properties.getScriptProperties().remove(PM_PARAM_DATAFILE);
        properties.getScriptProperties().remove(PM_PARAM_LOGFILE);
        properties.getScriptProperties().remove(PM_PARAM_CODEPAGE);
        properties.getScriptProperties().remove(MM_PARAM_DATABASE_NAME);
        properties.getScriptProperties().remove(MM_PARAM_DATAFILE);
        properties.getScriptProperties().remove(MM_PARAM_LOGFILE);
        properties.getScriptProperties().remove(MM_PARAM_CODEPAGE);
    }
}

