/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UnknownProductSuiteException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetDefaultNewTablespaceNames
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectionType;
    private final Map<String, String> m_fieldTablespaceMap = new HashMap<String, String>();

    public SetDefaultNewTablespaceNames(ConnectionClass connectionType, Map<String, String> fieldTablespaceMap) {
        this.m_connectionType = connectionType;
        this.m_fieldTablespaceMap.putAll(fieldTablespaceMap);
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError, DBMTException, UnknownProductSuiteException {
        Object productSuitekey = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY);
        if (productSuitekey != ProductSuiteType.PM && productSuitekey != ProductSuiteType.PPM) {
            return null;
        }
        String tablespaceBaseName = TablespaceUtil.getTablespaceBaseName(jobProps);
        HashSet<String> availableTablespaces = new HashSet<String>();
        if (PageInitializerHelper.isOracle(jobProps, data)) {
            try {
                availableTablespaces.addAll(TablespaceUtil.getAvailableTablespaces(jobProps.getConnection(this.m_connectionType)).keySet());
            }
            catch (ConnectionNotFoundException e) {
                return e.getLocalizedMessage();
            }
        }
        for (Map.Entry<String, String> entry : this.m_fieldTablespaceMap.entrySet()) {
            String tablespaceName = SetDefaultNewTablespaceNames.findTablespaceName(availableTablespaces, tablespaceBaseName, entry.getValue());
            data.getPageData(page).setValue(entry.getKey(), tablespaceName);
        }
        return null;
    }

    private static String findTablespaceName(Set<String> availableTablespaces, String tablespaceBaseName, String tablespaceSuffix) {
        int numericSuffix = 1;
        String canidateName = tablespaceBaseName + "_" + tablespaceSuffix + numericSuffix;
        while (availableTablespaces.contains(canidateName)) {
            canidateName = tablespaceBaseName + "_" + tablespaceSuffix + ++numericSuffix;
        }
        return canidateName;
    }
}

