/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.StrUtil;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.HashSet;

public class SSDatabasePrivPubPxrptUsersValid
implements TransitionMap.TransitionValidator {
    private final ConnectionClass m_connectionClassMaster;

    public SSDatabasePrivPubPxrptUsersValid(ConnectionClass connectionClassMaster) {
        this.m_connectionClassMaster = connectionClassMaster;
    }

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String usediffpasswd = "true";
        if ("true".equalsIgnoreCase(usediffpasswd)) {
            return this.validateDiffPasswords(data, jobProps, page);
        }
        return this.validateSamePassword(data, jobProps, page);
    }

    private String validateSamePassword(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        if (data.getValue(page, "password").isEmpty()) {
            return StringLocalizer.get("dbmt.error.install.passwordnotentered", new String[]{data.getValue(page, "privuser")});
        }
        if (!data.getValue(page, "password").equalsIgnoreCase(data.getValue(page, "confirmPassword"))) {
            return StringLocalizer.get("dbmt.error.install.passwordnotmatchconfirm", new String[]{data.getValue(page, "privuser")});
        }
        this.setSamePasswordForAll(data, jobProps, page);
        return null;
    }

    private void setSamePasswordForAll(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String password = data.getValue(page, "password");
        data.getPageData(page).setValue("privpass", password);
        data.getPageData(page).setValue("pxrptpass", password);
    }

    private String validateDiffPasswords(WizardInteractorData data, JobProperties jobProps, String page) throws ConnectionNotFoundException, InteractorDataError {
        String connectStringMaster = jobProps.getConnection(this.m_connectionClassMaster);
        String useExistingPrivUser = data.getValue(page, "useexistingpriv");
        String useExistingPubUser = data.getValue(page, "useexistingpub");
        String useExistingPxrptUser = data.getValue(page, "useexistingpxrptuser");
        String errorMsg = this.handlePrivUser(data, page, connectStringMaster, useExistingPrivUser);
        if (!StrUtil.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.handlePubUser(data, page, connectStringMaster);
        if (!StrUtil.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.handlePxrptUser(data, page, connectStringMaster);
        if (!StrUtil.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        errorMsg = this.verifyNoDupExistingUser(data, page, useExistingPrivUser, useExistingPubUser, useExistingPxrptUser);
        if (!StrUtil.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        return this.verifyNoDupNewUsers(data, page, useExistingPrivUser, useExistingPubUser, useExistingPxrptUser);
    }

    private String verifyNoDupNewUsers(WizardInteractorData data, String page, String useExistingPrivUser, String useExistingPubUser, String useExistingPxrptUser) throws InteractorDataError {
        if (!"true".equalsIgnoreCase(useExistingPrivUser) && !"true".equalsIgnoreCase(useExistingPubUser) && data.getValue(page, "privuser").equalsIgnoreCase(data.getValue(page, "pubuser"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "privuser")});
        }
        if (!"true".equalsIgnoreCase(useExistingPrivUser) && !"true".equalsIgnoreCase(useExistingPxrptUser) && data.getValue(page, "privuser").equalsIgnoreCase(data.getValue(page, "pxrptuser"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "privuser")});
        }
        if (!"true".equalsIgnoreCase(useExistingPubUser) && !"true".equalsIgnoreCase(useExistingPxrptUser) && data.getValue(page, "pubuser").equalsIgnoreCase(data.getValue(page, "pxrptuser"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "pubuser")});
        }
        return null;
    }

    private String verifyNoDupExistingUser(WizardInteractorData data, String page, String useExistingPrivUser, String useExistingPubUser, String useExistingPxrptUser) throws InteractorDataError {
        if ("true".equalsIgnoreCase(useExistingPrivUser) && "true".equalsIgnoreCase(useExistingPubUser) && data.getValue(page, "existingPriv").equalsIgnoreCase(data.getValue(page, "existingPub"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "existingPriv")});
        }
        if ("true".equalsIgnoreCase(useExistingPubUser) && "true".equalsIgnoreCase(useExistingPxrptUser) && data.getValue(page, "existingPub").equalsIgnoreCase(data.getValue(page, "existingPxrpt"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "existingPub")});
        }
        if ("true".equalsIgnoreCase(useExistingPrivUser) && "true".equalsIgnoreCase(useExistingPxrptUser) && data.getValue(page, "existingPriv").equalsIgnoreCase(data.getValue(page, "existingPxrpt"))) {
            return StringLocalizer.get("dbmt.error.install.userduplicates", new String[]{data.getValue(page, "existingPriv")});
        }
        return null;
    }

    private String handlePubUser(WizardInteractorData data, String page, String connectStringMaster) throws InteractorDataError {
        String pubuser = data.getValue(page, "pubuser");
        String password = data.getValue(page, "pubpass");
        String useExistingUser = data.getValue(page, "useexistingpub");
        String passwdConfirm = data.getValue(page, "pubpassconfirm");
        if (!"true".equalsIgnoreCase(useExistingUser)) {
            String errorMsg = this.verifyUserNotAlreadyExists(connectStringMaster, pubuser);
            if (!StrUtil.isEmpty((String)errorMsg)) {
                return errorMsg;
            }
            errorMsg = this.verifyPasswords(pubuser, password, passwdConfirm);
            if (!StrUtil.isEmpty((String)errorMsg)) {
                return errorMsg;
            }
        }
        return null;
    }

    private String handlePrivUser(WizardInteractorData data, String page, String connectStringMaster, String existingPrivUser) throws InteractorDataError {
        String userNameField = "privuser";
        String passwdField = "privpass";
        String useExistingUserBooleanField = "useexistingpriv";
        String existingUserField = "existingPriv";
        String passwdConfirmField = "privpassconfirm";
        return this.handleUser(data, page, connectStringMaster, userNameField, passwdField, useExistingUserBooleanField, existingUserField, passwdConfirmField);
    }

    private String handlePrivUserOld(WizardInteractorData data, String page, String connectStringMaster, String existingPrivUser) throws InteractorDataError {
        if ("true".equalsIgnoreCase(existingPrivUser)) {
            String privuser = data.getValue(page, "existingPriv");
            String privpass = data.getValue(page, "privpass");
            DBMTLogger.info(Channel.DEV, "Privuser " + privuser + " already exists.");
            String testConnection = privuser + "/" + privpass + connectStringMaster.substring(connectStringMaster.indexOf("@"));
            try {
                DBMTLogger.info(Channel.DEV, "Database test Connetion " + testConnection);
                DatabaseConnection tempconn = new DatabaseConnection(testConnection);
                tempconn.close();
            }
            catch (SQLException e) {
                return StringLocalizer.get("dbmt.error.install.useexistinguser", new String[]{privuser});
            }
        }
        try {
            DatabaseConnection conn = new DatabaseConnection(connectStringMaster);
            HashSet<String> usersSet = new HashSet<String>(SqlServerLogic.getDatabaseUsers(conn));
            String privuser = data.getValue(page, "privuser");
            if (usersSet.contains(privuser)) {
                return StringLocalizer.get("dbmt.error.install.alreadyexists", new String[]{privuser});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (data.getValue(page, "privpass").isEmpty()) {
            return StringLocalizer.get("dbmt.error.install.passwordnotentered", new String[]{data.getValue(page, "privuser")});
        }
        if (!data.getValue(page, "privpass").equalsIgnoreCase(data.getValue(page, "privpassconfirm"))) {
            return StringLocalizer.get("dbmt.error.install.passwordnotmatchconfirm", new String[]{data.getValue(page, "privuser")});
        }
        return null;
    }

    private String handlePxrptUser(WizardInteractorData data, String page, String connectStringMaster) throws InteractorDataError {
        String userNameField = "pxrptuser";
        String passwdField = "pxrptpass";
        String useExistingUserBooleanField = "useexistingpxrptuser";
        String existingUserField = "existingPxrpt";
        String passwdConfirmField = "pxrptpassconfirm";
        return this.handleUser(data, page, connectStringMaster, userNameField, passwdField, useExistingUserBooleanField, existingUserField, passwdConfirmField);
    }

    private String handleUser(WizardInteractorData data, String page, String connectStringMaster, String userNameField, String passwdField, String useExistingUserBooleanField, String existingUserField, String passwdConfirmField) throws InteractorDataError {
        String user = data.getValue(page, userNameField);
        String existingUser = data.getValue(page, existingUserField);
        String password = data.getValue(page, passwdField);
        String useExistingUser = data.getValue(page, useExistingUserBooleanField);
        String passwdConfirm = data.getValue(page, passwdConfirmField);
        if ("true".equalsIgnoreCase(useExistingUser)) {
            String errorMsg = this.verifyExistingUserPasswd(connectStringMaster, userNameField, existingUser, password);
            if (!StrUtil.isEmpty((String)errorMsg)) {
                return errorMsg;
            }
        } else {
            String errorMsg = this.verifyUserNotAlreadyExists(connectStringMaster, user);
            if (!StrUtil.isEmpty((String)errorMsg)) {
                return errorMsg;
            }
            errorMsg = this.verifyPasswords(user, password, passwdConfirm);
            if (!StrUtil.isEmpty((String)errorMsg)) {
                return errorMsg;
            }
        }
        return null;
    }

    private String verifyPasswords(String user, String password, String passwdConfirm) {
        if (password.isEmpty()) {
            return StringLocalizer.get("dbmt.error.install.passwordnotentered", new String[]{password});
        }
        if (!password.equalsIgnoreCase(passwdConfirm)) {
            return StringLocalizer.get("dbmt.error.install.passwordnotmatchconfirm", new String[]{user});
        }
        return null;
    }

    private String verifyUserNotAlreadyExists(String connectStringMaster, String user) {
        try {
            DatabaseConnection conn = new DatabaseConnection(connectStringMaster);
            HashSet<String> usersSet = new HashSet<String>(SqlServerLogic.getDatabaseUsers(conn));
            if (usersSet.contains(user)) {
                return StringLocalizer.get("dbmt.error.install.alreadyexists", new String[]{user});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String verifyExistingUserPasswd(String connectStringMaster, String userNameField, String existingUser, String password) {
        DBMTLogger.info(Channel.DEV, userNameField + " " + existingUser + " already exists.");
        String testConnection = existingUser + "/" + password + connectStringMaster.substring(connectStringMaster.lastIndexOf("@"));
        try {
            DBMTLogger.info(Channel.DEV, "Database test Connetion " + testConnection);
            DatabaseConnection tempconn = new DatabaseConnection(testConnection);
            tempconn.close();
        }
        catch (SQLException e) {
            return StringLocalizer.get("dbmt.error.install.useexistinguser", new String[]{existingUser});
        }
        return null;
    }
}

