/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import java.util.Map;

public abstract class ParameterizedDatabaseJobFactory<T extends Job>
implements ParameterizedJobFactory<T> {
    private final ConnectionClass m_connectionClass;

    public ParameterizedDatabaseJobFactory(ConnectionClass connectionClass) {
        this.m_connectionClass = connectionClass;
    }

    @Override
    public final T createJob(JobProperties props) throws ValueNotFound, ConnectionNotFoundException {
        String connection = null;
        if (this.m_connectionClass != null) {
            connection = props.getConnection(this.m_connectionClass);
        }
        this.printInfo(props);
        return this.createJob(props, connection);
    }

    private void printInfo(JobProperties props) {
        try {
            DBMTLogger.debug(Channel.DEV, "ConnectString " + props.getConnection(ConnectionClass.ADMINISTRATIVE));
            DBMTLogger.debug(Channel.DEV, "ConnectString " + props.getConnection(ConnectionClass.ADMINISTRATIVE));
        }
        catch (ConnectionNotFoundException e) {
            DBMTLogger.error(e.getLocalizedMessage());
        }
        DBMTLogger.debug(Channel.DEV, "Job: " + this.getClass());
        for (Map.Entry<Object, Object> entry : props.getJobPropertyEntries()) {
            DBMTLogger.debug(Channel.DEV, "Job Property " + entry.getKey() + " = " + entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : props.getScriptProperties().entrySet()) {
            DBMTLogger.debug(Channel.DEV, "Script Property " + entry.getKey() + " = " + entry.getValue());
        }
    }

    public abstract T createJob(JobProperties var1, String var2) throws ValueNotFound;
}

