/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.Arrays;
import java.util.List;

public class OracleATPUsersPasswordValidator
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        List<String> passwordFields = Arrays.asList("admpass", "admpassconfirm", "privpass", "privpassconfirm", "pubpass", "pubpassconfirm", "bgjobpass", "bgjobpassconfirm", "pxrptpass", "pxrptpassconfirm");
        List<String> userFields = Arrays.asList("admuser", "privuser", "pubuser", "bgjobuser", "pxrptuser");
        String passwordPattern = "(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?!.*[\"]).{12,30}";
        try {
            int passwordCount = 0;
            for (String user : userFields) {
                String value1;
                String field0 = passwordFields.get(passwordCount);
                String field1 = passwordFields.get(passwordCount + 1);
                String value0 = data.getValue(page, field0);
                if (value0.equals(value1 = data.getValue(page, field1)) && !user.equals(value0) && !user.equals(value1) && !value0.matches("(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?!.*[\"]).{12,30}")) {
                    throw new RuntimeException(StringLocalizer.get("dbmt.error.passwordvalidationfailed"));
                }
                passwordCount += 2;
            }
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

