/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.HomogeneousTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.TreeNode;
import com.primavera.database.tools.dbmt.actions.TreeNodeParent;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JobTreeTypeDef
extends HomogeneousTreeTypeDef<Job> {
    private final JobStatusInformer m_informer = new JobStatusInformer();
    private final JobRunner m_jobRunner = new JobRunner(this.m_informer);
    private final Map<Job, CommitPageDataDef.JobStatus> m_statusMap = new HashMap<Job, CommitPageDataDef.JobStatus>();

    private boolean allJobsFinished() {
        for (CommitPageDataDef.JobStatus status : this.m_statusMap.values()) {
            if (status == CommitPageDataDef.JobStatus.FINISHED) continue;
            return false;
        }
        return true;
    }

    public JobTreeTypeDef() {
        super(JobTreeTypeDefClass.class);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_statusMap.clear();
    }

    public JobRunnerInterface getJobRunner() {
        return this.m_jobRunner;
    }

    public void addListener(JobListener listener) {
        this.m_informer.addListener(listener);
    }

    public void removeListener(JobListener listener) {
        this.m_informer.removeListener(listener);
    }

    public JobListener getListener() {
        return this.m_informer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitPageDataDef.JobStatus getStatus(Job job) {
        CommitPageDataDef.JobStatus status = null;
        Map<Job, CommitPageDataDef.JobStatus> map = this.m_statusMap;
        synchronized (map) {
            status = this.m_statusMap.get(job);
        }
        if (status == null) {
            return CommitPageDataDef.JobStatus.NOTSTART;
        }
        return status;
    }

    private class JobStatusInformer
    extends JobListenerAdaptor {
        private final Set<JobListener> m_listeners = new HashSet<JobListener>();

        private JobStatusInformer() {
        }

        public synchronized void addListener(JobListener listener) {
            this.m_listeners.add(listener);
        }

        public synchronized void removeListener(JobListener listener) {
            this.m_listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void jobFailed(JobFailedEvent evt) {
            DBMTLogger.info(Channel.DEV, "Job Failed: " + evt.getJob());
            Map map = JobTreeTypeDef.this.m_statusMap;
            synchronized (map) {
                JobTreeTypeDef.this.m_statusMap.put(evt.getJob(), CommitPageDataDef.JobStatus.FAILED);
            }
            for (JobListener listener : this.m_listeners) {
                listener.jobFailed(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void jobFinished(JobFinishedEvent evt) {
            DBMTLogger.info(Channel.DEV, "Job Finished: " + evt.getJob());
            Map map = JobTreeTypeDef.this.m_statusMap;
            synchronized (map) {
                JobTreeTypeDef.this.m_statusMap.put(evt.getJob(), CommitPageDataDef.JobStatus.FINISHED);
            }
            for (JobListener listener : this.m_listeners) {
                listener.jobFinished(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void jobStarting(JobStartingEvent evt, boolean isIndeterminate) {
            DBMTLogger.info(Channel.DEV, "Job Starting: " + evt.getJob());
            Map map = JobTreeTypeDef.this.m_statusMap;
            synchronized (map) {
                JobTreeTypeDef.this.m_statusMap.put(evt.getJob(), CommitPageDataDef.JobStatus.RUNNING);
            }
            for (JobListener listener : this.m_listeners) {
                listener.jobStarting(evt, isIndeterminate);
            }
        }

        @Override
        public synchronized void jobProgressed(int processedStatements, int totalStatements) {
            for (JobListener listener : this.m_listeners) {
                listener.jobProgressed(processedStatements, totalStatements);
            }
        }
    }

    private class JobRunner
    implements Runnable,
    JobRunnerInterface {
        private Thread m_thread;
        private JobWatcher m_watcher;
        private final JobStatusInformer m_informer;
        private final List<Job> m_jobs = new ArrayList<Job>();
        private WizardRunner m_runner;

        private JobRunner(JobStatusInformer informer) {
            this.m_informer = informer;
        }

        @Override
        public void doThread(Thread th) {
            if (this.m_runner.commitAsync()) {
                th.start();
            } else {
                th.run();
            }
        }

        @Override
        public void runJobs(WizardRunner runner, List<Job> jobs) {
            this.m_runner = runner;
            this.m_jobs.addAll(jobs);
            this.m_thread = new Thread(this);
            this.m_watcher = new JobWatcher();
            if (runner.commitAsync()) {
                this.m_thread.start();
            } else {
                this.m_thread.run();
            }
        }

        @Override
        public void run() {
            this.m_runner.commit(this.m_informer, this.m_jobs, this.m_watcher);
        }

        @Override
        public boolean waitForFinish() {
            if (this.m_thread.getState() != Thread.State.TERMINATED) {
                try {
                    this.m_thread.join();
                }
                catch (InterruptedException e) {
                    DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.warn.jobthreadinterrupted"));
                }
            }
            this.m_thread = null;
            this.m_watcher = null;
            return JobTreeTypeDef.this.allJobsFinished();
        }

        @Override
        public void cancelJobs() {
            if (this.m_watcher != null) {
                this.m_watcher.stop();
            }
        }
    }

    public static class JobTreeTypeDefClass {
    }

    public static class JobParent
    implements TreeNodeParent<Job> {
        private final Job m_job;
        private final List<TreeNode<Job>> m_children = new ArrayList<TreeNode<Job>>();

        public JobParent(Job job) {
            this.m_job = job;
            ArrayList<JobNode> children = new ArrayList<JobNode>();
            for (Job subJob : job.subjobs()) {
                children.add(new JobNode(subJob));
            }
            this.m_children.addAll(children);
        }

        @Override
        public List<TreeNode<Job>> children() {
            return this.m_children;
        }

        public final Job getJob() {
            return this.m_job;
        }

        public int hashCode() {
            return this.m_job.hashCode();
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof TreeNode) {
                TreeNode node = (TreeNode)arg0;
                return this.m_job.equals(node.object());
            }
            return false;
        }
    }

    public static class JobNode
    extends JobParent
    implements TreeNode<Job> {
        public JobNode(Job job) {
            super(job);
        }

        @Override
        public Job object() {
            return this.getJob();
        }

        public String toString() {
            return this.getJob().toString();
        }
    }

    public static interface JobRunnerInterface {
        public void runJobs(WizardRunner var1, List<Job> var2);

        public boolean waitForFinish();

        public void cancelJobs();

        public void doThread(Thread var1);
    }
}

