/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorPageDef;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InteractorData {
    private Map<String, String> m_values = new HashMap<String, String>();
    private final InteractorPageDef m_def;
    private final Set<DataChangedListener> m_listeners = new HashSet<DataChangedListener>();
    private final Map<String, String> m_textValues = new HashMap<String, String>();

    public InteractorData(InteractorPageDef def) {
        this.m_def = def;
    }

    public String getDataPath() {
        return this.m_def.getDataPath();
    }

    public final String getString(String fieldId) throws InvalidDialogField {
        TypeDef def = this.m_def.getTypeDef(fieldId);
        if (def == null) {
            return null;
        }
        String obj = this.getValue(fieldId);
        if (obj == null) {
            return null;
        }
        return def.getNomalizedString(obj);
    }

    public final InteractorPageDef getDef() {
        return this.m_def;
    }

    public String getTitle() {
        return StringLocalizer.get(this.m_def.getNameKey());
    }

    public String getDesc() {
        return StringLocalizer.get(this.m_def.getDescKey());
    }

    public int getFieldCount() {
        return this.m_def.getSize();
    }

    public synchronized void addDataChangedListener(DataChangedListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removeDataChangedListener(DataChangedListener listener) {
        this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataChanged(String changedField) {
        HashSet<DataChangedListener> listenerSetCopy = new HashSet<DataChangedListener>();
        InteractorData interactorData = this;
        synchronized (interactorData) {
            listenerSetCopy.addAll(this.m_listeners);
        }
        for (DataChangedListener listener : listenerSetCopy) {
            listener.onDataChanged(this, changedField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String valueId, String value) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.interactor.error.unknownvalueid", new String[]{valueId}));
            return;
        }
        String normalizedValue = def.getTypeDef().getNomalizedString(value);
        Map<String, String> map = this.m_values;
        synchronized (map) {
            this.m_values.put(valueId, normalizedValue);
        }
        this.fireDataChanged(valueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String valueId) throws InvalidDialogField {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            throw new InvalidDialogField(valueId);
        }
        String value = null;
        Map<String, String> map = this.m_values;
        synchronized (map) {
            value = this.m_values.get(valueId);
        }
        if (value == null) {
            return def.getTypeDef().getNomalizedString(def.getDefaultValue());
        }
        return def.getTypeDef().getNomalizedString(value);
    }

    public Object defaultValue(String valueId) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            return null;
        }
        return def.getDefaultValue();
    }

    public Object defaultTypeDef(String valueId) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            return null;
        }
        return def.getTypeDef();
    }

    public String getTitle(String valueId) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            return null;
        }
        return StringLocalizer.get(def.getNameKey());
    }

    public String getDesc(String valueId) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            return null;
        }
        return StringLocalizer.get(def.getDescKey());
    }

    public char getMnemonic(String valueId) {
        ValueDef def = this.m_def.get(valueId);
        if (def == null) {
            return '\u0000';
        }
        String mnemonic = StringLocalizer.get(def.getMnemonicKey(), false);
        if (mnemonic == null || mnemonic.length() == 0) {
            return '\u0000';
        }
        return mnemonic.charAt(0);
    }

    public Iterable<String> getFieldIds() {
        return this.m_def.getKeys();
    }

    public Iterable<FieldTester> getFinishValidators() {
        return this.m_def.getFinishValidators();
    }

    public Iterable<String> getFinishDependencies() {
        return this.m_def.getFinishDependencies();
    }

    public boolean isCancel() {
        return this.m_def.isCancel();
    }

    public void setText(Iterable<String> ids) {
        this.setText(ids, new JobProperties());
    }

    public void setText(Iterable<String> ids, JobProperties props) {
        for (String id : ids) {
            this.m_textValues.put(id, this.m_def.getText(id, props));
        }
    }

    public String getText(String id) {
        return this.m_textValues.get(id);
    }

    public Iterable<String> getTextIds() {
        return this.m_textValues.keySet();
    }

    public String toString() {
        return "InteractorData[def=" + this.m_def + " values=" + this.m_values + "]";
    }
}

