/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.FieldTable;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ProcessedParam;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class GenericScriptParamaterSetter
implements TransitionMap.TransitionOperation {
    private final FieldTable m_fields;

    public GenericScriptParamaterSetter(FieldTable fields) {
        this.m_fields = fields;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        for (String scriptParam : this.m_fields.getParams()) {
            ProcessedParam wizardParam = this.m_fields.getParam(scriptParam);
            String wizardValue = data.getValue(page, wizardParam.getFieldName());
            if (wizardValue == null) {
                wizardValue = "";
            }
            try {
                jobProps.getScriptProperties().put(scriptParam, wizardParam.getProc().process(wizardValue));
            }
            catch (Exception e) {
                return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            }
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        for (String scriptParam : this.m_fields.getParams()) {
            properties.getScriptProperties().remove(scriptParam);
        }
    }
}

