/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.ContextLogic;
import com.primavera.database.tools.dbmt.DataAccessFailureFailed;
import com.primavera.database.tools.dbmt.DialogActionLogic;
import com.primavera.database.tools.dbmt.actions.DialogRunner;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataDef;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.RunnerFactoryManager;

public abstract class DialogActionOperation<T extends ContextLogic>
implements ActionOperation,
DialogActionLogic {
    private InteractorDataDef m_dataDef;
    private String m_path;
    private String m_nameKey;
    private String m_descKey;
    private T m_contextLogic;

    public DialogActionOperation(T contextLogic) {
        this.m_contextLogic = contextLogic;
    }

    public T contextLogic() {
        return this.m_contextLogic;
    }

    @Override
    public final void perform() throws ActionFailed {
        InteractorData data = new InteractorData(this.m_dataDef);
        try {
            this.prepareData(data);
            DialogRunner runner = RunnerFactoryManager.inst().getDialogRunnerFactory().createDialogRunner(data, this.m_path);
            if (runner.runDialog(this)) {
                this.performDialogAction(data);
            }
        }
        catch (InteractorDataError e) {
            throw new DataAccessFailureFailed(this, e);
        }
    }

    public abstract void performDialogAction(InteractorData var1) throws ActionFailed, InteractorDataError;

    @Override
    public String canAccept(InteractorData data) throws InteractorDataError {
        return null;
    }

    @Override
    public void prepareData(InteractorData data) throws InteractorDataError {
    }

    public final InteractorDataDef getDataDef() {
        return this.m_dataDef;
    }

    public final void setDataDef(InteractorDataDef dataDef) {
        this.m_dataDef = dataDef;
    }

    @Override
    public final String getActionPath() {
        return this.m_path;
    }

    public final void setActionPath(String path) {
        this.m_path = path;
    }

    @Override
    public final String getDescKey() {
        return this.m_descKey;
    }

    public final void setDescKey(String descKey) {
        this.m_descKey = descKey;
    }

    @Override
    public final String getNameKey() {
        return this.m_nameKey;
    }

    public final void setNameKey(String nameKey) {
        this.m_nameKey = nameKey;
    }
}

