/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.DBMTLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleDriver;

public class DatabaseSrcCode {
    private static DatabaseConnection m_conn;

    public DatabaseSrcCode(DatabaseConnection conn) {
        m_conn = conn;
    }

    public static void processSource(String adminUserName) {
        String filename = "orpm_src.sql";
        DatabaseSrcCode.gatherSourcecode(filename, adminUserName);
    }

    private static void gatherSourcecode(String filename, String objOwner) {
        try {
            String workingDirectory = System.getProperty("user.dir");
            DriverManager.registerDriver(new OracleDriver());
            String sqlStatement = "select object_name,object_type from user_objects where object_type in ('FUNCTION','PROCEDURE','PACKAGE','PACKAGE BODY','TRIGGER') order by object_type";
            List<String> objLists = DatabaseSrcCode.getObjectLists(m_conn, sqlStatement);
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            for (String string : objLists) {
                String[] vals = string.split(",");
                out.write("--METADATA TYPE:ROLLBACK GROUP:REVERT_SOURCE NAME:REVERT_SOURCE ");
                out.write(10);
                out.write("CREATE OR REPLACE ");
                DatabaseSrcCode.appendSourcecode(out, workingDirectory, vals[0], vals[1]);
                out.write(10);
                out.write("/");
                out.write(10);
            }
            out.close();
            fstream.close();
            m_conn.close();
        }
        catch (Exception e) {
            DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.grant.system.to.admin.unsuccessMessage"));
            return;
        }
    }

    private static void appendSourcecode(BufferedWriter out, String dirName, String objname, String objtyp) {
        try {
            String sqlStatement = "select text from user_source where type= '" + objtyp + "' and name= '" + objname + "'";
            Statement stmt = m_conn.getConnection().createStatement();
            ResultSet resultSet = stmt.executeQuery(sqlStatement);
            while (resultSet.next()) {
                String sourceRows = resultSet.getString("text");
                if (sourceRows.length() <= 2499) {
                    out.write(sourceRows);
                    continue;
                }
                out.write(sourceRows.substring(0, 2498));
                out.write(10);
                out.write(sourceRows.substring(2499));
            }
            stmt.close();
        }
        catch (IOException | SQLException e) {
            DBMTLogger.warn(StringLocalizer.get("dbmt.rollback.grant.system.to.admin.unsuccessMessage"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getObjectLists(DatabaseConnection conn, String query) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Statement stmt = conn.getConnection().createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                ret.add(rs.getString(1) + "," + rs.getString(2));
            }
        }
        return ret;
    }

    private static void deleteSourcecode(String fileAbsPath) {
        String OS = System.getProperty("os.name").toLowerCase();
        String fileSeparater = "";
        if (OS.indexOf("win") >= 0) {
            fileSeparater = "\\";
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) {
            fileSeparater = "/";
        } else if (OS.indexOf("sunos") >= 0) {
            fileSeparater = "/";
        } else {
            System.out.println("Your OS is not support!!");
        }
        String filename = "orpm_src.sql";
        String srcCodeDir = System.getProperty("user.dir");
        String fileAbsDelPath = srcCodeDir + fileSeparater + filename;
        try {
            File file = new File(fileAbsDelPath);
            if (file.delete()) {
                System.out.println(file.getName() + " is deleted!");
            } else {
                System.out.println("Delete operation is failed.");
            }
        }
        catch (Exception e) {
            System.out.println("File Delete Error.");
        }
    }
}

