/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.BaseWizardProgressor;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.JobTreeTypeDef;
import com.primavera.database.tools.dbmt.actions.WizardActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;

public class CommitPageProgressor<T extends WizardActionOperation>
extends BaseWizardProgressor<T> {
    public CommitPageProgressor(T action, String page) {
        super(action, page);
    }

    @Override
    protected boolean shouldPreparePage(WizardRunner runner) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
        JobTreeTypeDef typeDef;
        JobTreeTypeDef jobTreeTypeDef = typeDef = (JobTreeTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("job-tree");
        synchronized (jobTreeTypeDef) {
            typeDef.reset();
            ArrayList<JobTreeTypeDef.JobNode> currentJobs = new ArrayList<JobTreeTypeDef.JobNode>();
            for (Job job : runner.currentJobs(runner.stack())) {
                currentJobs.add(new JobTreeTypeDef.JobNode(job));
            }
            typeDef.getTopLevel().addAll(currentJobs);
            typeDef.addListener(new CommitJobListener(data));
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (Job job : runner.currentJobs(runner.stack())) {
                jobs.add(job);
            }
            typeDef.getJobRunner().runJobs(runner, jobs);
            new CommitFinishInformer(typeDef.getJobRunner(), data.getPageData(this.getPage()));
        }
    }

    @Override
    public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        runner.clearAllJobs();
        runner.stack().clear();
        try {
            JobTreeTypeDef typeDef = (JobTreeTypeDef)data.getPageData(this.getPage()).getDef().getTypeDef("job-tree");
            typeDef.reset();
        }
        catch (Throwable e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }

    @Override
    public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
    }

    private class CommitJobListener
    extends JobListenerAdaptor {
        private boolean alreadyFailed = false;
        private final WizardInteractorData m_data;

        private CommitJobListener(WizardInteractorData data) {
            this.m_data = data;
        }

        @Override
        public void jobStarting(JobStartingEvent evt, boolean isIndeterminate) {
            try {
                if (isIndeterminate) {
                    this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("job-pct", Double.toString(Double.NaN));
                } else {
                    this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("job-pct", "0");
                }
            }
            catch (InteractorDataError e) {
                e.printStackTrace();
            }
        }

        @Override
        public void jobFinished(JobFinishedEvent evt) {
            try {
                this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("job-pct", Double.toString(100.0));
            }
            catch (InteractorDataError e) {
                e.printStackTrace();
            }
        }

        @Override
        public void jobFailed(JobFailedEvent evt) {
            try {
                if (!this.alreadyFailed) {
                    this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("status-msg", evt.toString());
                    this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("commit-status", CommitPageDataDef.CommitStatus.FAILED.toString());
                    this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("job-pct", Double.toString(0.5));
                }
                this.alreadyFailed = true;
            }
            catch (InteractorDataError e) {
                DBMTLogger.error(Channel.USER, e.getLocalizedMessage());
            }
        }

        @Override
        public void jobProgressed(int processedStatements, int totalStatements) {
            try {
                if (totalStatements == 0) {
                    return;
                }
                this.m_data.getPageData(CommitPageProgressor.this.getPage()).setValue("job-pct", Double.toString((double)processedStatements / (double)totalStatements));
            }
            catch (InteractorDataError e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class CommitFinishInformer {
        public CommitFinishInformer(final JobTreeTypeDef.JobRunnerInterface runner, final InteractorData pageData) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean finishedOk = runner.waitForFinish();
                    if (finishedOk) {
                        pageData.setValue("commit-status", CommitPageDataDef.CommitStatus.FINISHED.toString());
                    } else {
                        pageData.setValue("commit-status", CommitPageDataDef.CommitStatus.FAILED.toString());
                    }
                }
            });
            runner.doThread(thread);
        }
    }
}

