/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class AddPXConnectionTransOp
extends SetConnectStringTransOp {
    public AddPXConnectionTransOp(boolean verify, Properties fieldOverrides) {
        super(ConnectionClass.PX, verify, fieldOverrides);
    }

    public AddPXConnectionTransOp(boolean verify) {
        this(verify, new Properties());
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pxUserName = data.getPageData(page).getValue("pxdmuser");
        String pxPassword = data.getPageData(page).getValue("pxdmpass");
        String adminConnection = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        return this.createConnectionFromExistingConnectionForNewUser(adminConnection, pxUserName, pxPassword);
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pxUserName = data.getPageData(page).getValue("pxdmuser");
        String pxPassword = data.getPageData(page).getValue("pxdmpass");
        String adminConnection = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedConnection = new ConnectStringParse(adminConnection);
        String instance = parsedConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setDatabase(instance);
        info.setUsername(pxUserName);
        String connectionString = info.createATPConnectString(pxPassword, parsedConnection.getConnectstring());
        return connectionString;
    }
}

