/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.List;

public class AddPMUpgradeJobs
extends AbstractJobAdder {
    private final ApplicationContextLogic m_contextLogic;

    public AddPMUpgradeJobs(String pageId, ApplicationContextLogic contextLogic, Object installedDBVersionKey) {
        super(pageId, installedDBVersionKey);
        this.m_contextLogic = contextLogic;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, DBMTException {
        ActionClass createActionClass = AbstractJobAdder.getActionClass(ActionType.UPGRADE, jobProps);
        List<SchemaInfo> schemas = AbstractJobAdder.getSchemaInfo(jobProps);
        for (SchemaInfo schemaInfo : schemas) {
            if (schemaInfo.getSchemaType() == SchemaType.JR) continue;
            List<ParameterizedJobFactory<?>> jobFactories = this.m_contextLogic.getApp().getSchemaSteps(schemaInfo, createActionClass);
            for (ParameterizedJobFactory<?> factory : jobFactories) {
                Object job = factory.createJob(jobProps);
                jobs.add((Job)job);
            }
        }
    }
}

