/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.CSDFRecord;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.GCDFRecord;
import com.primavera.database.tools.RetrieveExpCustomFieldInfo;
import com.primavera.database.tools.RetrieveExpCustomfieldInfoFromDatabase;
import com.primavera.database.tools.RetrieveExpCustomfieldInfoFromSampleDataZip;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.InvalidCustomColumnDatasourceException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.WorkflowStepJob;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.workflow.ExpeditionCSDFCustomColumnJob;
import com.primavera.database.tools.dbmt.workflow.ExpeditionGCDFCustomColumnJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AddExpeditionCustomColumnJobs
extends AbstractJobAdder {
    private final Object m_dataSourceKey;

    public AddExpeditionCustomColumnJobs(String pageId, Object dataSourceKey) {
        super(pageId);
        this.m_dataSourceKey = dataSourceKey;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        jobs.add(this.getCustomFieldInfoSource(jobProps));
    }

    protected Job getCustomFieldInfoSource(JobProperties jobProps) throws ConnectionNotFoundException, InvalidCustomColumnDatasourceException, JobPropertyNotFound {
        Object connectStringObject = jobProps.getJobProperty(this.m_dataSourceKey);
        if (connectStringObject == null) {
            throw new RuntimeException("Datasource connection is null");
        }
        String connectString = connectStringObject.toString();
        ConnectStringParse parsedConnectionString = new ConnectStringParse(connectString);
        if (parsedConnectionString.getConnectionType() == DSType.DATABASE) {
            RetrieveExpCustomfieldInfoFromDatabase dbRetriever = new RetrieveExpCustomfieldInfoFromDatabase(connectString);
            return this.createJobFromRetrievers(dbRetriever.m_csdfRecordRetriever, dbRetriever.m_gcdfRecordRetriever, jobProps.getConnection(ConnectionClass.ADMINISTRATIVE));
        }
        if (parsedConnectionString.getConnectionType() == DSType.SAMPLE) {
            for (Map.Entry<Object, Object> entry : jobProps.getJobPropertyEntries()) {
                DBMTLogger.info(Channel.DEV, " ------- " + entry.getKey() + " = " + entry.getValue());
            }
            List schemaInfoList = (List)jobProps.getJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
            if (schemaInfoList == null || schemaInfoList.isEmpty()) {
                throw new JobPropertyNotFound(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
            }
            RetrieveExpCustomfieldInfoFromSampleDataZip retriever = new RetrieveExpCustomfieldInfoFromSampleDataZip(connectString, (SchemaInfo)schemaInfoList.get(0));
            return this.createJobFromRetrievers(retriever.m_csdfRecordRetriever, retriever.m_gcdfRecordRetriever, jobProps.getConnection(ConnectionClass.ADMINISTRATIVE));
        }
        throw new InvalidCustomColumnDatasourceException(connectString);
    }

    private Job createJobFromRetrievers(RetrieveExpCustomFieldInfo<CSDFRecord> csdfRecordRetriever, RetrieveExpCustomFieldInfo<GCDFRecord> gcdfRecordRetriever, String targetConnectString) {
        ArrayList<Job> jobList = new ArrayList<Job>();
        jobList.add(new ExpeditionCSDFCustomColumnJob(csdfRecordRetriever, targetConnectString));
        jobList.add(new ExpeditionGCDFCustomColumnJob(gcdfRecordRetriever, targetConnectString));
        return new WorkflowStepJob(StringLocalizer.get("dbmt.customcolumns.job.jobname"), null, jobList);
    }
}

