/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.charconv.CharConvBuilderJob;
import java.util.List;

public class AddCharConversionJobs
extends AbstractJobAdder {
    public AddCharConversionJobs(String pageId) {
        super(pageId);
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        DBMTLogger.info(Channel.DEV, "Adding Jobs");
        String connString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        String src = data.getValue("select_character_set", "sourcechar");
        String dst = data.getValue("select_character_set", "destchar");
        String tables = data.getPageData("select_character_set").getDef().getText("tables", jobProps);
        jobs.add(new CharConvBuilderJob(connString, src, dst, tables));
    }
}

