/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class AddBGUserTransOp
extends SetConnectStringTransOp {
    public AddBGUserTransOp(boolean verify, Properties fieldOverrides) {
        super(ConnectionClass.UTILITY, verify, fieldOverrides);
    }

    public AddBGUserTransOp(boolean verify) {
        this(verify, new Properties());
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String bgUserName = data.getPageData(page).getValue("bgjobuser");
        String bgPassword = data.getPageData(page).getValue("bgjobpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        String host = parsedAdminConnection.getServer();
        String port = parsedAdminConnection.getPort();
        String instance = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setHost(host);
        info.setPort(Integer.parseInt(port));
        info.setDatabase(instance);
        info.setUsername(bgUserName);
        info.setService(parsedAdminConnection.isOracleService());
        return info.createConnectString(bgPassword);
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String bgUserName = data.getPageData(page).getValue("bgjobuser");
        String bgPassword = data.getPageData(page).getValue("bgjobpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        OracleServerInfo info = new OracleServerInfo("", "", "");
        String dbService = parsedAdminConnection.getDatabase();
        info.setDatabase(dbService);
        info.setUsername(bgUserName);
        String connectString = parsedAdminConnection.getConnectstring();
        return info.createATPConnectString(bgPassword, connectString);
    }
}

