/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import java.sql.SQLException;

public abstract class AbstractSetUpgradeSchemaType
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        try {
            ProductSuiteType suiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
            SchemaType schemaType = this.getSchemaType(jobProps.getConnection(ConnectionClass.ADMINISTRATIVE), suiteType);
            if (suiteType == ProductSuiteType.PPM && schemaType == SchemaType.PM) {
                schemaType = SchemaType.PPM;
            }
            jobProps.setJobProperty(InstallSuiteOptionKeys.PRODUCT_UPGRADE_KEY, (Object)schemaType);
        }
        catch (SQLException e) {
            return e.getLocalizedMessage();
        }
        catch (SchemaTypeNotFoundError e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.PRODUCT_UPGRADE_KEY);
    }

    protected abstract SchemaType getSchemaType(String var1, ProductSuiteType var2) throws SQLException, SchemaTypeNotFoundError;
}

