/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.util.SchemaVersionsCompare;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractJobAdder
implements TransitionMap.TransitionOperation {
    private final String m_pageId;
    private final Object m_installedDBVersionKey;

    public AbstractJobAdder(String pageId, Object installedDBVersionKey) {
        this.m_pageId = pageId;
        this.m_installedDBVersionKey = installedDBVersionKey;
    }

    public AbstractJobAdder(String pageId) {
        this(pageId, null);
    }

    @Override
    public final String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        ArrayList<Job> jobsToAdd = new ArrayList<Job>();
        this.getJobsToAdd(data, jobProps, jobsToAdd);
        DBMTLogger.info(Channel.DEV, "About to add " + jobsToAdd.size() + " jobs");
        String installedDBVersion = null;
        if (this.m_installedDBVersionKey != null) {
            installedDBVersion = jobProps.getJobProperty(this.m_installedDBVersionKey).toString();
        }
        for (Job job : jobsToAdd) {
            String maxDBVersion;
            if (job == null || (maxDBVersion = job.getMaxVersion()) != null && SchemaVersionsCompare.versionGreaterThanOrEqualTo(installedDBVersion, job.getMaxVersion())) continue;
            DBMTLogger.info(Channel.DEV, "\tAdding job " + job.getClass().getSimpleName() + " (" + job.toString() + ")");
            runner.addJob(this.m_pageId, job);
        }
        DBMTLogger.info(Channel.DEV, "Finished adding " + jobsToAdd.size() + " jobs");
        return null;
    }

    @Override
    public final void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        runner.removePageJobs(this.m_pageId);
    }

    protected abstract void getJobsToAdd(WizardInteractorData var1, JobProperties var2, List<Job> var3) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException;

    public static List<SchemaInfo> getSchemaInfo(JobProperties jobProps) throws DBMTException {
        ArrayList<SchemaInfo> schemaInfoList = new ArrayList<SchemaInfo>();
        Object schemaInfoListObj = jobProps.getJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
        if (schemaInfoListObj != null && schemaInfoListObj instanceof List) {
            for (Object obj : (List)schemaInfoListObj) {
                if (!(obj instanceof SchemaInfo)) continue;
                schemaInfoList.add((SchemaInfo)obj);
            }
        }
        return schemaInfoList;
    }

    public static ActionClass getActionClass(ActionType actionType, JobProperties jobProps) throws JobPropertyNotFound {
        Object serverTypeObj = jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY);
        if (serverTypeObj instanceof ServerType) {
            ServerType serverType = (ServerType)((Object)serverTypeObj);
            if (serverType.equals((Object)ServerType.ORACLEATP) && !actionType.equals((Object)ActionType.DBUSERS)) {
                serverType = ServerType.ORACLE;
            }
            return new ActionClass(actionType, serverType);
        }
        return null;
    }
}

